/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cfr;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.fabricmc.loom.decompilers.LoomInternalDecompiler;
import net.fabricmc.loom.decompilers.cfr.CFRObfuscationMapping;
import net.fabricmc.loom.decompilers.cfr.CFRSinkFactory;
import org.benf.cfr.reader.Driver;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.SinkDumperFactory;

public final class LoomCFRDecompiler
implements LoomInternalDecompiler {
    private static final Map<String, String> DECOMPILE_OPTIONS = Map.of("renameillegalidents", "true", "trackbytecodeloc", "true", "comments", "false");

    @Override
    public void decompile(LoomInternalDecompiler.Context context) {
        Map<String, Map<Integer, Integer>> lineMap;
        Path compiledJar = context.compiledJar();
        String path = compiledJar.toAbsolutePath().toString();
        HashMap<String, String> allOptions = new HashMap<String, String>(DECOMPILE_OPTIONS);
        allOptions.putAll(context.options());
        Options options = OptionsImpl.getFactory().create(allOptions);
        ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(options);
        for (Path library : context.libraries()) {
            classFileSource.addJarContent(library.toAbsolutePath().toString(), AnalysisType.JAR);
        }
        classFileSource.informAnalysisRelativePathDetail(null, null);
        DCCommonState state = new DCCommonState(options, classFileSource);
        if (context.javaDocs() != null) {
            state = new DCCommonState(state, new CFRObfuscationMapping(context.javaDocs()));
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (JarOutputStream outputStream = new JarOutputStream(Files.newOutputStream(context.sourcesDestination(), new OpenOption[0]), manifest);){
            CFRSinkFactory cfrSinkFactory = new CFRSinkFactory(outputStream, context.logger());
            SinkDumperFactory dumperFactory = new SinkDumperFactory(cfrSinkFactory, options);
            Driver.doJar(state, path, AnalysisType.JAR, dumperFactory);
            lineMap = cfrSinkFactory.getLineMap();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to decompile", e);
        }
        this.writeLineMap(context.linemapDestination(), lineMap);
    }

    private void writeLineMap(Path output, Map<String, Map<Integer, Integer>> lineMap) {
        if (lineMap.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Map.Entry<String, Map<Integer, Integer>> classEntry : lineMap.entrySet()) {
                String name = classEntry.getKey().replace(".", "/");
                Map<Integer, Integer> mapping = classEntry.getValue();
                int maxLine = 0;
                int maxLineDest = 0;
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Integer, Integer> mappingEntry : mapping.entrySet()) {
                    int src = mappingEntry.getKey();
                    int dst = mappingEntry.getValue();
                    maxLine = Math.max(maxLine, src);
                    maxLineDest = Math.max(maxLineDest, dst);
                    builder.append("\t").append(src).append("\t").append(dst).append("\n");
                }
                writer.write(String.format(Locale.ENGLISH, "%s\t%d\t%d\n", name, maxLine, maxLineDest));
                writer.write(builder.toString());
                writer.write("\n");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write line map", e);
        }
    }
}

