/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.service.ClasspathGroupService;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateDLIConfigTask
extends AbstractLoomTask {
    @Input
    protected abstract Property<String> getVersionInfoJson();

    @Input
    protected abstract Property<String> getMinecraftVersion();

    @Input
    protected abstract Property<Boolean> getSplitSourceSets();

    @Input
    protected abstract Property<Boolean> getPlainConsole();

    @Input
    protected abstract Property<Boolean> getANSISupportedIDE();

    @Input
    protected abstract Property<String> getLog4jConfigPaths();

    @Input
    @Optional
    protected abstract Property<String> getClientGameJarPath();

    @Input
    @Optional
    protected abstract Property<String> getCommonGameJarPath();

    @Input
    protected abstract Property<String> getAssetsDirectoryPath();

    @Input
    protected abstract Property<String> getNativesDirectoryPath();

    @InputFile
    public abstract RegularFileProperty getRemapClasspathFile();

    @OutputFile
    protected abstract RegularFileProperty getDevLauncherConfig();

    @Nested
    protected abstract Property<ClasspathGroupService.Options> getClasspathGroupOptions();

    public GenerateDLIConfigTask() {
        this.getVersionInfoJson().set((Object)LoomGradlePlugin.GSON.toJson((Object)this.getExtension().getMinecraftProvider().getVersionInfo()));
        this.getMinecraftVersion().set((Object)this.getExtension().getMinecraftProvider().minecraftVersion());
        this.getSplitSourceSets().set((Object)this.getExtension().areEnvironmentSourceSetsSplit());
        this.getANSISupportedIDE().set((Object)GenerateDLIConfigTask.ansiSupportedIde(this.getProject()));
        this.getPlainConsole().set((Object)(this.getProject().getGradle().getStartParameter().getConsoleOutput() == ConsoleOutput.Plain ? 1 : 0));
        this.getClasspathGroupOptions().set(ClasspathGroupService.create(this.getProject()));
        this.getLog4jConfigPaths().set((Object)GenerateDLIConfigTask.getAllLog4JConfigFiles(this.getProject()));
        if (((Boolean)this.getSplitSourceSets().get()).booleanValue()) {
            this.getClientGameJarPath().set((Object)this.getGameJarPath("client"));
            this.getCommonGameJarPath().set((Object)this.getGameJarPath("common"));
        }
        this.getAssetsDirectoryPath().set((Object)new File(this.getExtension().getFiles().getUserCache(), "assets").getAbsolutePath());
        this.getNativesDirectoryPath().set((Object)this.getExtension().getFiles().getNativesDirectory(this.getProject()).getAbsolutePath());
        this.getDevLauncherConfig().set(this.getExtension().getFiles().getDevLauncherConfig());
    }

    @TaskAction
    public void run() throws IOException {
        MinecraftVersionMeta versionInfo = (MinecraftVersionMeta)LoomGradlePlugin.GSON.fromJson((String)this.getVersionInfoJson().get(), MinecraftVersionMeta.class);
        File assetsDirectory = new File((String)this.getAssetsDirectoryPath().get());
        if (versionInfo.assets().equals("legacy")) {
            assetsDirectory = new File(assetsDirectory, "/legacy/" + versionInfo.id());
        }
        LaunchConfig launchConfig = new LaunchConfig().property("fabric.development", "true").property("fabric.remapClasspathFile", ((RegularFile)this.getRemapClasspathFile().get()).getAsFile().getAbsolutePath()).property("log4j.configurationFile", (String)this.getLog4jConfigPaths().get()).property("log4j2.formatMsgNoLookups", "true").argument("client", "--assetIndex").argument("client", versionInfo.assetIndex().fabricId((String)this.getMinecraftVersion().get())).argument("client", "--assetsDir").argument("client", assetsDirectory.getAbsolutePath());
        if (versionInfo.hasNativesToExtract()) {
            String nativesPath = (String)this.getNativesDirectoryPath().get();
            launchConfig.property("client", "java.library.path", nativesPath).property("client", "org.lwjgl.librarypath", nativesPath);
        }
        if (((Boolean)this.getSplitSourceSets().get()).booleanValue()) {
            launchConfig.property("client", "fabric.gameJarPath.client", (String)this.getClientGameJarPath().get());
            launchConfig.property("fabric.gameJarPath", (String)this.getCommonGameJarPath().get());
        }
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            ClasspathGroupService classpathGroupService = (ClasspathGroupService)serviceFactory.get(this.getClasspathGroupOptions());
            if (classpathGroupService.hasGroups()) {
                launchConfig.property("fabric.classPathGroups", classpathGroupService.getClasspathGroupsPropertyValue());
            }
        }
        if (((Boolean)this.getANSISupportedIDE().get()).booleanValue() && !((Boolean)this.getPlainConsole().get()).booleanValue()) {
            launchConfig.property("fabric.log.disableAnsi", "false");
        }
        Files.writeString(((File)this.getDevLauncherConfig().getAsFile().get()).toPath(), (CharSequence)launchConfig.asString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String getAllLog4JConfigFiles(Project project) {
        return LoomGradleExtension.get(project).getLog4jConfigs().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
    }

    private String getGameJarPath(String env) {
        MappedMinecraftProvider.Split split = (MappedMinecraftProvider.Split)((Object)this.getExtension().getNamedMinecraftProvider());
        return switch (env) {
            case "client" -> split.getClientOnlyJar().getPath().toAbsolutePath().toString();
            case "common" -> split.getCommonJar().getPath().toAbsolutePath().toString();
            default -> throw new UnsupportedOperationException();
        };
    }

    private static boolean ansiSupportedIde(Project project) {
        File rootDir = project.getRootDir();
        return new File(rootDir, ".vscode").exists() || new File(rootDir, ".idea").exists() || new File(rootDir, ".project").exists() || Arrays.stream(rootDir.listFiles()).anyMatch(file -> file.getName().endsWith(".iws"));
    }

    public static class LaunchConfig {
        private final Map<String, List<String>> values = new HashMap<String, List<String>>();

        public LaunchConfig property(String key, String value) {
            return this.property("common", key, value);
        }

        public LaunchConfig property(String side, String key, String value) {
            this.values.computeIfAbsent(side + "Properties", s -> new ArrayList()).add(String.format("%s=%s", key, value));
            return this;
        }

        public LaunchConfig argument(String value) {
            return this.argument("common", value);
        }

        public LaunchConfig argument(String side, String value) {
            this.values.computeIfAbsent(side + "Args", s -> new ArrayList()).add(value);
            return this;
        }

        public String asString() {
            StringJoiner stringJoiner = new StringJoiner("\n");
            for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
                stringJoiner.add(entry.getKey());
                for (String s : entry.getValue()) {
                    stringJoiner.add("\t" + s);
                }
            }
            return stringJoiner.toString();
        }
    }
}

