/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.configuration.LoomConfigurations;
import net.fabricmc.loom.util.Strings;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.SourceSet;

public record DebofConfiguration(String name, List<Function<SourceSet, String>> configurationFunctions) {
    public static final DebofConfiguration COMPILE = new DebofConfiguration("compile", List.of(SourceSet::getImplementationConfigurationName, SourceSet::getApiConfigurationName, SourceSet::getCompileOnlyConfigurationName));
    public static final DebofConfiguration RUNTIME = new DebofConfiguration("runtime", List.of(SourceSet::getImplementationConfigurationName, SourceSet::getApiConfigurationName, SourceSet::getRuntimeOnlyConfigurationName));
    public static final List<DebofConfiguration> ALL = List.of(COMPILE, RUNTIME);

    public Configuration getConfiguration(Project project, TargetSourceSet targetSourceSet) {
        return project.getConfigurations().getByName(this.resolveConfigurationName(targetSourceSet));
    }

    public List<Configuration> getConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        return TargetSourceSet.applicable(project).stream().map(this::resolveConfigurationName).map(arg_0 -> ((ConfigurationContainer)configurations).getByName(arg_0)).toList();
    }

    private String resolveConfigurationName(TargetSourceSet targetSourceSet) {
        return "%s%sDependencyResolve".formatted(targetSourceSet.name, Strings.capitalize(this.name()));
    }

    public static void create(Project project) {
        for (DebofConfiguration debofConfiguration : ALL) {
            debofConfiguration.createResolveConfiguration(project);
        }
    }

    public void createResolveConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        for (TargetSourceSet target : TargetSourceSet.applicable(project)) {
            SourceSet sourceSet = target.getSourceSet(project);
            configurations.register(this.resolveConfigurationName(target), c -> {
                LoomConfigurations.Role.RESOLVABLE.apply((Configuration)c);
                for (Function<SourceSet, String> configProvider : this.configurationFunctions()) {
                    Configuration sourceConfig = configurations.getByName(configProvider.apply(sourceSet));
                    c.extendsFrom(new Configuration[]{sourceConfig});
                }
            });
        }
    }

    public static enum TargetSourceSet {
        MAIN("main", e -> Boolean.TRUE),
        CLIENT("client", LoomGradleExtensionAPI::areEnvironmentSourceSetsSplit);

        private final String name;
        private final Function<LoomGradleExtension, Boolean> enabled;

        private TargetSourceSet(String name, Function<LoomGradleExtension, Boolean> enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public SourceSet getSourceSet(Project project) {
            return SourceSetHelper.getSourceSetByName(this.name, project);
        }

        public static List<TargetSourceSet> applicable(Project project) {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            return Arrays.stream(TargetSourceSet.values()).filter(targetSourceSet -> targetSourceSet.enabled.apply(extension)).toList();
        }
    }
}

