/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.speccontext.DebofConfiguration;
import net.fabricmc.loom.configuration.processors.speccontext.DeobfProjectView;
import net.fabricmc.loom.util.AsyncCache;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public record DeobfSpecContext(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<FabricModJson> modDependenciesCompileRuntime, List<FabricModJson> modDependenciesCompileRuntimeClient) implements SpecContext
{
    public static DeobfSpecContext create(Project project) {
        return DeobfSpecContext.create(new DeobfProjectView.Impl(project));
    }

    public static DeobfSpecContext create(DeobfProjectView projectView) {
        Set<String> clientTransformingModIds;
        AsyncCache<List<FabricModJson>> fmjCache = new AsyncCache<List<FabricModJson>>();
        List<FabricModJson> dependentMods = DeobfSpecContext.getDependentMods(projectView, fmjCache);
        Map mods = dependentMods.stream().collect(HashMap::new, (map, mod) -> map.put(mod.getId(), mod), Map::putAll);
        FileCollection mainRuntimeClasspath = projectView.getDependencies(DebofConfiguration.RUNTIME, DebofConfiguration.TargetSourceSet.MAIN);
        FileCollection mainCompileClasspath = projectView.getDependencies(DebofConfiguration.COMPILE, DebofConfiguration.TargetSourceSet.MAIN);
        Set<String> mainTransformingModIds = DeobfSpecContext.common(DeobfSpecContext.getModIds(mainRuntimeClasspath, fmjCache), DeobfSpecContext.getModIds(mainCompileClasspath, fmjCache));
        if (projectView.areEnvironmentSourceSetsSplit()) {
            FileCollection clientRuntimeClasspath = projectView.getDependencies(DebofConfiguration.RUNTIME, DebofConfiguration.TargetSourceSet.CLIENT);
            FileCollection clientCompileClasspath = projectView.getDependencies(DebofConfiguration.COMPILE, DebofConfiguration.TargetSourceSet.CLIENT);
            clientTransformingModIds = DeobfSpecContext.common(DeobfSpecContext.getModIds(clientRuntimeClasspath, fmjCache), DeobfSpecContext.getModIds(clientCompileClasspath, fmjCache));
        } else {
            clientTransformingModIds = Set.of();
        }
        return new DeobfSpecContext(dependentMods, projectView.getMods(), DeobfSpecContext.getMods(mods, DeobfSpecContext.combine(mainTransformingModIds, clientTransformingModIds)), DeobfSpecContext.getMods(mods, DeobfSpecContext.onlyInLeft(clientTransformingModIds, mainTransformingModIds)));
    }

    private static List<FabricModJson> getDependentMods(DeobfProjectView projectView, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        Set artifacts = projectView.getFullClasspath().getFiles();
        for (File artifact : artifacts) {
            futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(artifact.toPath()).map(List::of).orElseGet(List::of)));
        }
        if (!projectView.disableProjectDependantMods()) {
            for (Project dependentProject : SpecContext.getDependentProjects(projectView).toList()) {
                futures.add(fmjCache.get(dependentProject.getPath(), () -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        return SpecContext.distinctSorted(AsyncCache.joinList(futures));
    }

    private static Set<String> getModIds(FileCollection configuration, AsyncCache<List<FabricModJson>> fmjCache) {
        ArrayList futures = new ArrayList();
        Set artifacts = configuration.getFiles();
        for (File artifact : artifacts) {
            futures.add(fmjCache.get(artifact.toPath().toAbsolutePath().toString(), () -> FabricModJsonFactory.createFromZipOptional(artifact.toPath()).map(List::of).orElseGet(List::of)));
        }
        return SpecContext.distinctSorted(AsyncCache.joinList(futures)).stream().map(FabricModJson::getId).collect(HashSet::new, Set::add, Set::addAll);
    }

    private static List<FabricModJson> getMods(Map<String, FabricModJson> mods, Set<String> ids) {
        ArrayList<FabricModJson> result = new ArrayList<FabricModJson>();
        for (String id : ids) {
            result.add(Objects.requireNonNull(mods.get(id), "Could not find mod with id: " + id));
        }
        return result;
    }

    private static Set<String> common(Set<String> a, Set<String> b) {
        HashSet<String> copy = new HashSet<String>(a);
        copy.retainAll(b);
        return copy;
    }

    private static Set<String> combine(Set<String> a, Set<String> b) {
        HashSet<String> copy = new HashSet<String>(a);
        copy.addAll(b);
        return copy;
    }

    private static Set<String> onlyInLeft(Set<String> left, Set<String> right) {
        HashSet<String> copy = new HashSet<String>(left);
        copy.removeAll(right);
        return copy;
    }
}

