/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import groovy.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.ide.idea.IdeaSyncTask;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class RunConfig {
    public String configName;
    public String eclipseProjectName;
    public String ideaModuleName;
    public String mainClass;
    public String runDirIdeaUrl;
    public String runDir;
    public String environment;
    public List<String> vmArgs = new ArrayList<String>();
    public List<String> programArgs = new ArrayList<String>();
    public transient SourceSet sourceSet;
    public Map<String, Object> environmentVariables;
    public String projectName;
    public String folderName;

    private static String capitalizeCamelCaseName(String name) {
        if (name.length() == 0) {
            return "";
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1).replaceAll("([^A-Z])([A-Z])", "$1 $2");
    }

    public static RunConfig runConfig(Project project, RunConfigSettings settings) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        LibraryContext context = new LibraryContext(extension.getMinecraftProvider().getVersionInfo(), JavaVersion.current());
        if (settings.getEnvironment().equals("client") && context.usesLWJGL3()) {
            settings.startFirstThread();
        }
        String name = settings.getName();
        Object configName = settings.getConfigName();
        String environment = settings.getEnvironment();
        SourceSet sourceSet = settings.getSource(project);
        String mainClass = (String)settings.getMainClass().getOrNull();
        if (mainClass == null) {
            throw new IllegalArgumentException("Run configuration '" + name + "' must specify 'mainClass'");
        }
        if (configName == null) {
            boolean isSplitClientSourceSet;
            configName = "";
            String srcName = sourceSet.getName();
            boolean bl = isSplitClientSourceSet = extension.areEnvironmentSourceSetsSplit() && srcName.equals("client") && environment.equals("client");
            if (!srcName.equals("main") && !isSplitClientSourceSet) {
                configName = (String)configName + RunConfig.capitalizeCamelCaseName(srcName) + " ";
            }
            configName = (String)configName + "Minecraft " + RunConfig.capitalizeCamelCaseName(name);
        }
        Objects.requireNonNull(environment, "No environment set for run config");
        String runDir = settings.getRunDir();
        if (runDir == null) {
            runDir = "run";
        }
        boolean appendProjectPath = (Boolean)settings.getAppendProjectPathToConfigName().get();
        RunConfig runConfig = new RunConfig();
        runConfig.configName = configName;
        if (appendProjectPath && !GradleUtils.isRootProject(project)) {
            runConfig.configName = runConfig.configName + " (" + project.getPath() + ")";
        }
        runConfig.mainClass = (String)settings.devLaunchMainClass().get();
        runConfig.vmArgs.add("-Dfabric.dli.config=" + RunConfig.encodeEscaped(extension.getFiles().getDevLauncherConfig().getAbsolutePath()));
        runConfig.vmArgs.add("-Dfabric.dli.env=" + environment.toLowerCase());
        runConfig.eclipseProjectName = ((EclipseModel)project.getExtensions().getByType(EclipseModel.class)).getProject().getName();
        runConfig.ideaModuleName = IdeaUtils.getIdeaModuleName(new SourceSetReference(sourceSet, project));
        runConfig.runDirIdeaUrl = "file://$PROJECT_DIR$/" + runDir;
        runConfig.runDir = runDir;
        runConfig.sourceSet = sourceSet;
        runConfig.environment = environment;
        runConfig.programArgs.addAll(settings.getProgramArgs());
        runConfig.vmArgs.addAll(settings.getVmArgs());
        runConfig.vmArgs.add("-Dfabric.dli.main=" + mainClass);
        runConfig.environmentVariables = new HashMap<String, Object>();
        runConfig.environmentVariables.putAll(settings.getEnvironmentVariables());
        runConfig.projectName = project.getName();
        runConfig.folderName = (String)settings.getIdeConfigFolder().getOrNull();
        MinecraftVersionMeta.JavaVersion javaVersion = extension.getMinecraftProvider().getVersionInfo().javaVersion();
        if (javaVersion != null && javaVersion.majorVersion() >= 25) {
            runConfig.vmArgs.add("--sun-misc-unsafe-memory-access=allow");
            runConfig.vmArgs.add("--enable-native-access=ALL-UNNAMED");
        }
        return runConfig;
    }

    public String fromDummy(String dummy, boolean relativeDir, Project project) throws IOException {
        String dummyConfig;
        try (InputStream input = IdeaSyncTask.class.getClassLoader().getResourceAsStream(dummy);){
            dummyConfig = new String(input.readAllBytes(), StandardCharsets.UTF_8);
        }
        Object runDir = this.runDir;
        if (relativeDir && project.getRootProject() != project) {
            Path rootPath = project.getRootDir().toPath();
            Path projectPath = project.getProjectDir().toPath();
            String relativePath = rootPath.relativize(projectPath).toString();
            runDir = relativePath + "/" + (String)runDir;
        }
        dummyConfig = dummyConfig.replace("%NAME%", this.configName);
        dummyConfig = dummyConfig.replace("%MAIN_CLASS%", this.mainClass);
        dummyConfig = dummyConfig.replace("%ECLIPSE_PROJECT%", this.eclipseProjectName);
        dummyConfig = dummyConfig.replace("%IDEA_MODULE%", this.ideaModuleName);
        dummyConfig = dummyConfig.replace("%RUN_DIRECTORY%", (CharSequence)runDir);
        dummyConfig = dummyConfig.replace("%PROGRAM_ARGS%", RunConfig.joinArguments(this.programArgs).replaceAll("\"", "&quot;"));
        dummyConfig = dummyConfig.replace("%VM_ARGS%", RunConfig.joinArguments(this.vmArgs).replaceAll("\"", "&quot;"));
        dummyConfig = dummyConfig.replace("%IDEA_ENV_VARS%", this.getEnvVars("<env name=\"%s\" value=\"%s\"/>"));
        dummyConfig = dummyConfig.replace("%ECLIPSE_ENV_VARS%", this.getEnvVars("<mapEntry key=\"%s\" value=\"%s\"/>"));
        dummyConfig = dummyConfig.replace("%IDEA_FOLDER_NAME%", (CharSequence)(this.folderName == null ? "" : "folderName=\"" + XmlUtil.escapeXml((String)this.folderName) + "\""));
        return dummyConfig;
    }

    private String getEnvVars(String pattern) {
        return this.environmentVariables.entrySet().stream().map(entry -> pattern.formatted(entry.getKey(), entry.getValue().toString())).collect(Collectors.joining());
    }

    public static String joinArguments(List<String> args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            if (arg.contains(" ")) {
                sb.append("\"").append(arg).append("\"");
                continue;
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    static String getMainClass(String side, LoomGradleExtension extension, String defaultMainClass) {
        InstallerData installerData = extension.getInstallerData();
        if (installerData == null) {
            return defaultMainClass;
        }
        JsonObject installerJson = installerData.installerJson();
        if (installerJson != null && installerJson.has("mainClass")) {
            JsonElement mainClassJson = installerJson.get("mainClass");
            String mainClassName = "";
            if (mainClassJson.isJsonObject()) {
                JsonObject mainClassesJson = mainClassJson.getAsJsonObject();
                if (mainClassesJson.has(side)) {
                    mainClassName = mainClassesJson.get(side).getAsString();
                }
            } else {
                mainClassName = mainClassJson.getAsString();
            }
            return mainClassName;
        }
        return defaultMainClass;
    }

    public List<String> getExcludedLibraryPaths(Project project) {
        if (!this.environment.equals("server")) {
            return Collections.emptyList();
        }
        BundleMetadata bundleMetadata = LoomGradleExtension.get(project).getMinecraftProvider().getServerBundleMetadata();
        if (bundleMetadata == null) {
            return Collections.emptyList();
        }
        Set<ResolvedArtifact> clientLibraries = RunConfig.getArtifacts(project, "minecraftClientRuntimeLibraries");
        Set<ResolvedArtifact> serverLibraries = RunConfig.getArtifacts(project, "minecraftServerRuntimeLibraries");
        LinkedList<String> clientOnlyLibraries = new LinkedList<String>();
        for (ResolvedArtifact library : clientLibraries) {
            if (RunConfig.containsLibrary(serverLibraries, library.getModuleVersion().getId())) continue;
            clientOnlyLibraries.add(library.getFile().getAbsolutePath());
        }
        return clientOnlyLibraries;
    }

    private static Set<ResolvedArtifact> getArtifacts(Project project, String configuration) {
        return project.getConfigurations().getByName(configuration).getHierarchy().stream().map(c -> c.getResolvedConfiguration().getResolvedArtifacts()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static boolean containsLibrary(Set<ResolvedArtifact> artifacts, ModuleVersionIdentifier identifier) {
        return artifacts.stream().map(ResolvedArtifact::getModuleVersion).map(ResolvedModuleVersion::getId).anyMatch(test -> test.getGroup().equals(identifier.getGroup()) && test.getName().equals(identifier.getName()));
    }

    private static String encodeEscaped(String s) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '@' && i > 0 && s.charAt(i - 1) == '@' || c == ' ') {
                ret.append(String.format(Locale.ENGLISH, "@@%04x", (int)c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

