/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public record ClassLineNumbers(Map<String, Entry> lineMap) {
    public ClassLineNumbers {
        Objects.requireNonNull(lineMap, "lineMap");
        if (lineMap.isEmpty()) {
            throw new IllegalArgumentException("lineMap is empty");
        }
        for (Map.Entry<String, Entry> entry : lineMap.entrySet()) {
            Objects.requireNonNull(entry.getKey(), "lineMap key");
            Objects.requireNonNull(entry.getValue(), "lineMap value");
        }
    }

    public static ClassLineNumbers readMappings(BufferedReader reader) {
        HashMap<String, Entry> lineMap = new HashMap<String, Entry>();
        String line = null;
        int lineNumber = 0;
        record CurrentClass(String className, int maxLine, int maxLineDest) {
            void putEntry(Map<String, Entry> entries, Map<Integer, Integer> mappings) {
                Entry entry = new Entry(this.className(), this.maxLine(), this.maxLineDest(), Collections.unmodifiableMap(mappings));
                Entry previous = entries.put(this.className(), entry);
                if (previous != null) {
                    throw new IllegalStateException("Duplicate class line mappings for " + this.className());
                }
            }
        }
        CurrentClass currentClass = null;
        HashMap<Integer, Integer> currentMappings = new HashMap<Integer, Integer>();
        boolean didRead = false;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                didRead = true;
                String[] segments = line.trim().split("\t");
                if (line.charAt(0) != '\t') {
                    if (currentClass != null) {
                        currentClass.putEntry(lineMap, currentMappings);
                        currentMappings = new HashMap();
                    }
                    currentClass = new CurrentClass(segments[0], Integer.parseInt(segments[1]), Integer.parseInt(segments[2]));
                } else {
                    Objects.requireNonNull(currentClass, "No class line mappings found for line " + lineNumber);
                    currentMappings.put(Integer.parseInt(segments[0]), Integer.parseInt(segments[1]));
                }
                ++lineNumber;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Exception reading mapping line @{0}: {1}", lineNumber, line), e);
        }
        if (!didRead) {
            throw new IllegalArgumentException("Unable to read empty linemap data");
        }
        currentClass.putEntry(lineMap, currentMappings);
        return new ClassLineNumbers(Collections.unmodifiableMap(lineMap));
    }

    public void write(Writer writer) throws IOException {
        for (Map.Entry<String, Entry> entry : this.lineMap.entrySet()) {
            entry.getValue().write(writer);
        }
    }

    public static @Nullable ClassLineNumbers merge(@Nullable ClassLineNumbers a, @Nullable ClassLineNumbers b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        HashMap<String, Entry> lineMap = new HashMap<String, Entry>(a.lineMap());
        for (Map.Entry<String, Entry> entry : b.lineMap().entrySet()) {
            lineMap.merge(entry.getKey(), entry.getValue(), (v1, v2) -> {
                throw new IllegalStateException("Duplicate class line mappings for " + (String)entry.getKey());
            });
        }
        return new ClassLineNumbers(Collections.unmodifiableMap(lineMap));
    }

    public record Entry(String className, int maxLine, int maxLineDest, Map<Integer, Integer> lineMap) {
        public void write(Writer writer) throws IOException {
            writer.write(this.className);
            writer.write(9);
            writer.write(Integer.toString(this.maxLine));
            writer.write(9);
            writer.write(Integer.toString(this.maxLineDest));
            writer.write(10);
            for (Map.Entry<Integer, Integer> lineEntry : this.lineMap.entrySet()) {
                writer.write(9);
                writer.write(Integer.toString(lineEntry.getKey()));
                writer.write(9);
                writer.write(Integer.toString(lineEntry.getValue()));
                writer.write(10);
            }
        }
    }
}

