/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.fernflower;

import java.io.IOException;
import net.fabricmc.loom.decompilers.LoomInternalDecompiler;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

public class FernflowerLogger
extends IFernflowerLogger {
    private final LoomInternalDecompiler.Logger logger;

    public FernflowerLogger(LoomInternalDecompiler.Logger logger) {
        this.logger = logger;
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (message.contains("Inconsistent inner class entries for")) {
            return;
        }
        if (message.contains("Inconsistent generic signature in method")) {
            return;
        }
        System.err.println(message);
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        this.writeMessage(message, severity);
    }

    private void write(String data) {
        try {
            this.logger.accept(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to log", e);
        }
    }

    public void startReadingClass(String className) {
        this.write("Decompiling " + className);
    }

    public void startClass(String className) {
        this.write("Decompiling " + className);
    }

    public void startWriteClass(String className) {
    }

    public void startMethod(String methodName) {
    }

    public void endMethod() {
    }
}

