/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateRemapClasspathTask
extends AbstractLoomTask {
    @InputFiles
    public abstract ConfigurableFileCollection getRemapClasspath();

    @OutputFile
    public abstract RegularFileProperty getRemapClasspathFile();

    public GenerateRemapClasspathTask() {
        ConfigurationContainer configurations = this.getProject().getConfigurations();
        this.getRemapClasspath().from(new Object[]{configurations.named("minecraftLibraries")});
        this.getExtension().getRuntimeRemapConfigurations().stream().map(RemapConfigurationSettings::getName).map(arg_0 -> ((ConfigurationContainer)configurations).named(arg_0)).forEach(arg_0 -> GenerateRemapClasspathTask.lambda$new$0(this.getRemapClasspath(), arg_0));
        for (Path minecraftJar : this.getExtension().getMinecraftJars((MappingsNamespace)((Object)this.getExtension().getProductionNamespaceEnum().get()))) {
            this.getRemapClasspath().from(new Object[]{minecraftJar.toFile()});
        }
        this.getRemapClasspathFile().set(this.getExtension().getFiles().getRemapClasspathFile());
    }

    @TaskAction
    public void run() {
        ArrayList remapClasspath = new ArrayList(this.getRemapClasspath().getFiles());
        String str = remapClasspath.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        try {
            Files.writeString(((File)this.getRemapClasspathFile().getAsFile().get()).toPath(), (CharSequence)str, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate remap classpath", e);
        }
    }

    private static /* synthetic */ void lambda$new$0(ConfigurableFileCollection rec$, Object xva$0) {
        rec$.from(new Object[]{xva$0});
    }
}

