/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.parchment;

import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.parchment.ParchmentPrefixStripingMappingVisitor;
import net.fabricmc.loom.configuration.providers.mappings.parchment.ParchmentTreeV1;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingVisitor;

public record ParchmentMappingLayer(Path parchmentFile, boolean removePrefix) implements MappingLayer
{
    private static final String PARCHMENT_DATA_FILE_NAME = "parchment.json";

    @Override
    public void visit(MappingVisitor mappingVisitor) throws IOException {
        ParchmentTreeV1 parchmentData = this.getParchmentData();
        if (this.removePrefix()) {
            mappingVisitor = new ParchmentPrefixStripingMappingVisitor((MappingVisitor)mappingVisitor);
        }
        parchmentData.visit((MappingVisitor)mappingVisitor, MappingsNamespace.NAMED.toString());
    }

    private ParchmentTreeV1 getParchmentData() throws IOException {
        return ZipUtils.unpackJson(this.parchmentFile, PARCHMENT_DATA_FILE_NAME, ParchmentTreeV1.class);
    }
}

