/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.tool;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.LoomProblems;
import net.fabricmc.loom.util.LoomVersions;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.ApiStatus;

@UntrackedTask(because="Enigma should always launch")
public abstract class ModEnigmaTask
extends AbstractLoomTask {
    private static final ProblemId MAPPINGS_MISSING_PROBLEM = LoomProblems.problemId("mappings-missing", "Mapping file doesn't exist");
    private static final String ENIGMA_MAIN_CLASS = "cuchaz.enigma.gui.Main";

    @Input
    public abstract ListProperty<Path> getMinecraftJars();

    @OutputFile
    public abstract RegularFileProperty getMappingFile();

    @Classpath
    public abstract ConfigurableFileCollection getToolClasspath();

    @Inject
    @ApiStatus.Internal
    protected abstract ExecOperations getExecOperations();

    @Inject
    @ApiStatus.Internal
    protected abstract Problems getProblems();

    public ModEnigmaTask() {
        this.getMinecraftJars().convention(this.getProject().provider(() -> this.getExtension().getMinecraftJars((MappingsNamespace)((Object)((Object)this.getExtension().getProductionNamespace().get())))));
        this.getToolClasspath().from(new Object[]{ModEnigmaTask.getEnigmaClasspath(this.getProject())});
    }

    private static FileCollection getEnigmaClasspath(Project project) {
        Dependency enigmaDep = project.getDependencies().create((Object)LoomVersions.ENIGMA_SWING.mavenNotation());
        return project.getConfigurations().detachedConfiguration(new Dependency[]{enigmaDep});
    }

    @TaskAction
    public void launch() {
        Path mappingFile = ((RegularFile)this.getMappingFile().get()).getAsFile().toPath().toAbsolutePath();
        if (Files.notExists(mappingFile, new LinkOption[0])) {
            ProblemReporter reporter = this.getProblems().getReporter();
            reporter.throwing((Throwable)new RuntimeException("Mapping file " + String.valueOf(mappingFile) + " doesn't exist"), MAPPINGS_MISSING_PROBLEM, spec -> spec.fileLocation(mappingFile.toString()).solution("Create the missing mapping file. Remember to add it to the fabric.mod.json if needed!"));
        }
        this.getExecOperations().javaexec(spec -> {
            spec.getMainClass().set((Object)ENIGMA_MAIN_CLASS);
            spec.setClasspath((FileCollection)this.getToolClasspath());
            spec.jvmArgs(new Object[]{"-Xmx2048m"});
            for (Path path : (List)this.getMinecraftJars().get()) {
                spec.args(new Object[]{"-jar", path.toAbsolutePath().toString()});
            }
            spec.args(new Object[]{"-mappings", mappingFile.toString()});
        });
    }
}

