/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loom.util.download.DownloadException;
import net.fabricmc.loom.util.download.DownloadResult;

public class DownloadExecutor
implements AutoCloseable {
    private final ExecutorService executorService;
    private final List<DownloadException> downloadExceptions = Collections.synchronizedList(new ArrayList());

    public DownloadExecutor(int threads) {
        this.executorService = Executors.newFixedThreadPool(threads);
    }

    CompletableFuture<DownloadResult> runAsync(DownloadRunner downloadRunner) {
        if (!this.downloadExceptions.isEmpty()) {
            return CompletableFuture.failedFuture(new DownloadException("Download blocked due to previous errors"));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return downloadRunner.run();
            }
            catch (DownloadException e) {
                this.executorService.shutdownNow();
                this.downloadExceptions.add(e);
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public void close() throws DownloadException {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!this.downloadExceptions.isEmpty()) {
            DownloadException downloadException = new DownloadException("Failed to download");
            for (DownloadException suppressed : this.downloadExceptions) {
                downloadException.addSuppressed(suppressed);
            }
            throw downloadException;
        }
    }

    @FunctionalInterface
    public static interface DownloadRunner {
        public DownloadResult run() throws DownloadException;
    }
}

