/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.fernflower;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.decompilers.LoomInternalDecompiler;
import net.fabricmc.loom.decompilers.fernflower.FernflowerLogger;
import net.fabricmc.loom.decompilers.fernflower.ThreadSafeResultSaver;
import net.fabricmc.loom.decompilers.fernflower.TinyJavadocProvider;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public final class FabricFernFlowerDecompiler
implements LoomInternalDecompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompile(LoomInternalDecompiler.Context context) {
        Path sourcesDestination = context.sourcesDestination();
        Path linemapDestination = context.linemapDestination();
        HashMap<String, TinyJavadocProvider> options = new HashMap<String, TinyJavadocProvider>(Map.of("dgs", "1", "bsm", "1", "rsy", "1", "log", "trace", "thr", String.valueOf(context.numberOfThreads()), "ind", "\t", "fabric:javadoc", new TinyJavadocProvider(context.javaDocs().toFile())));
        options.putAll(context.options());
        ThreadSafeResultSaver saver = new ThreadSafeResultSaver(sourcesDestination::toFile, linemapDestination::toFile);
        Fernflower ff = new Fernflower((externalPath, internalPath) -> this.getBytecode(externalPath, internalPath, context), (IResultSaver)saver, options, (IFernflowerLogger)new FernflowerLogger(context.logger()));
        for (Path library : context.libraries()) {
            ff.addLibrary(library.toFile());
        }
        ff.addSource(context.compiledJar().toFile());
        try {
            ff.decompileContext();
        }
        finally {
            ff.clearContext();
        }
    }

    private byte[] getBytecode(String externalPath, String internalPath, LoomInternalDecompiler.Context context) throws IOException {
        File file = new File(externalPath);
        if (internalPath == null) {
            return InterpreterUtil.getBytes((File)file);
        }
        return context.unpackZip(file.toPath(), internalPath);
    }
}

