/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftClassMerger;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.SnowmanClassVisitor;
import net.fabricmc.loom.util.SyntheticParameterClassVisitor;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class MinecraftJarMerger
implements AutoCloseable {
    private final MinecraftClassMerger classMerger = new MinecraftClassMerger();
    private final FileSystemUtil.Delegate inputClientFs;
    private final FileSystemUtil.Delegate inputServerFs;
    private final FileSystemUtil.Delegate outputFs;
    private final Path inputClient;
    private final Path inputServer;
    private final Map<String, Entry> entriesClient;
    private final Map<String, Entry> entriesServer;
    private final Set<String> entriesAll;
    private boolean removeSnowmen = false;
    private boolean offsetSyntheticsParams = false;

    public MinecraftJarMerger(File inputClient, File inputServer, File output) throws IOException {
        if (output.exists() && !output.delete()) {
            throw new IOException("Could not delete " + output.getName());
        }
        Files.createDirectories(output.toPath().getParent(), new FileAttribute[0]);
        this.inputClientFs = FileSystemUtil.getJarFileSystem(inputClient, false);
        this.inputClient = this.inputClientFs.get().getPath("/", new String[0]);
        this.inputServerFs = FileSystemUtil.getJarFileSystem(inputServer, false);
        this.inputServer = this.inputServerFs.get().getPath("/", new String[0]);
        this.outputFs = FileSystemUtil.getJarFileSystem(output, true);
        this.entriesClient = new HashMap<String, Entry>();
        this.entriesServer = new HashMap<String, Entry>();
        this.entriesAll = new TreeSet<String>();
    }

    public void enableSnowmanRemoval() {
        this.removeSnowmen = true;
    }

    public void enableSyntheticParamsOffset() {
        this.offsetSyntheticsParams = true;
    }

    @Override
    public void close() throws IOException {
        this.inputClientFs.close();
        this.inputServerFs.close();
        this.outputFs.close();
    }

    private void readToMap(final Map<String, Entry> map, Path input) {
        try {
            Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                    if (attr.isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!path.getFileName().toString().endsWith(".class")) {
                        if (path.toString().equals("/META-INF/MANIFEST.MF")) {
                            map.put("META-INF/MANIFEST.MF", new Entry(path, attr, "Manifest-Version: 1.0\nMain-Class: net.minecraft.client.Main\n".getBytes(StandardCharsets.UTF_8)));
                        } else {
                            if (path.toString().startsWith("/META-INF/") && (path.toString().endsWith(".SF") || path.toString().endsWith(".RSA"))) {
                                return FileVisitResult.CONTINUE;
                            }
                            map.put(path.toString().substring(1), new Entry(path, attr));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    map.put(path.toString().substring(1), new Entry(path, attr, Lazy.of(() -> {
                        try {
                            return Files.readAllBytes(path);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Failed to read " + String.valueOf(path), e);
                        }
                    })));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read", e);
        }
    }

    private void add(Entry entry) {
        try {
            byte[] data;
            Path outPath = this.outputFs.get().getPath(entry.path.toString(), new String[0]);
            if (outPath.getParent() != null) {
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            }
            if ((data = entry.data()) != null) {
                Files.write(outPath, data, StandardOpenOption.CREATE_NEW);
            } else {
                Files.copy(entry.path, outPath, new CopyOption[0]);
            }
            Files.getFileAttributeView(outPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(entry.metadata.creationTime(), entry.metadata.lastAccessTime(), entry.metadata.lastModifiedTime());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to write " + String.valueOf(entry.path), ioe);
        }
    }

    public void merge() throws IOException {
        try (ExecutorService service = Executors.newFixedThreadPool(2);){
            service.submit(() -> this.readToMap(this.entriesClient, this.inputClient));
            service.submit(() -> this.readToMap(this.entriesServer, this.inputServer));
        }
        this.entriesAll.addAll(this.entriesClient.keySet());
        this.entriesAll.addAll(this.entriesServer.keySet());
        service = Executors.newWorkStealingPool();
        try {
            for (String entry : this.entriesAll) {
                this.processEntry(entry, service);
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    private void processEntry(String entry, Executor executor) {
        boolean isClass = entry.endsWith(".class");
        boolean isMinecraft = this.entriesClient.containsKey(entry) || entry.startsWith("net/minecraft") || !entry.contains("/");
        Result r = this.getResult(entry, isClass);
        if (isClass && !isMinecraft && "SERVER".equals(r.side())) {
            return;
        }
        if (isMinecraft && isClass) {
            CompletableFuture.supplyAsync(() -> this.mergeClass(entry, r), executor).thenAccept(this::add);
            return;
        }
        CompletableFuture.runAsync(() -> this.add(r.entry), executor);
    }

    private Result getResult(String entry, boolean isClass) {
        Entry result;
        String side = null;
        Entry clientEntry = this.entriesClient.get(entry);
        Entry serverEntry = this.entriesServer.get(entry);
        if (clientEntry != null && serverEntry != null) {
            byte[] serverData;
            byte[] clientData = clientEntry.data();
            if (Arrays.equals(clientData, serverData = serverEntry.data())) {
                result = clientEntry;
            } else if (isClass) {
                Objects.requireNonNull(clientData);
                Objects.requireNonNull(serverData);
                result = new Entry(clientEntry.path, clientEntry.metadata, this.classMerger.merge(clientData, serverData));
            } else {
                result = clientEntry;
            }
        } else {
            result = clientEntry;
            if (result != null) {
                side = "CLIENT";
            } else {
                result = serverEntry;
                if (result != null) {
                    side = "SERVER";
                }
            }
        }
        return new Result(result, side);
    }

    private Entry mergeClass(String entry, Result result) {
        ClassWriter writer;
        byte[] data = result.entry().data();
        Objects.requireNonNull(data, "Class data cannot be null");
        ClassReader reader = new ClassReader(data);
        Object visitor = writer = new ClassWriter(0);
        if (result.side() != null) {
            visitor = new MinecraftClassMerger.SidedClassVisitor(589824, (ClassVisitor)visitor, result.side());
        }
        if (this.removeSnowmen) {
            visitor = new SnowmanClassVisitor(589824, (ClassVisitor)visitor);
        }
        if (this.offsetSyntheticsParams && !entry.contains("/")) {
            visitor = new SyntheticParameterClassVisitor(589824, (ClassVisitor)visitor);
        }
        if (visitor != writer) {
            reader.accept((ClassVisitor)visitor, 0);
            data = writer.toByteArray();
            return new Entry(result.entry().path, result.entry().metadata, data);
        }
        return result.entry();
    }

    public record Entry(Path path, BasicFileAttributes metadata, @Nullable Supplier<byte[]> dataSupplier) {
        public Entry(Path path, BasicFileAttributes metadata, byte @Nullable [] data) {
            this(path, metadata, () -> data);
        }

        public Entry(Path path, BasicFileAttributes metadata) {
            this(path, metadata, (Supplier<byte[]>)null);
        }

        byte @Nullable [] data() {
            if (this.dataSupplier == null) {
                return null;
            }
            return this.dataSupplier.get();
        }
    }

    private record Result(Entry entry, @Nullable String side) {
    }
}

