/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.loom.nativeplatform.LoomNativePlatform;
import net.fabricmc.loom.nativeplatform.LoomNativePlatformException;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ProcessUtil;
import net.fabricmc.loom.util.gradle.daemon.DaemonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtil.class);

    public static <E, C extends Throwable> E createDescriptiveWrapper(BiFunction<String, C, E> constructor, String message, C cause) {
        String descriptiveMessage = "%s, %s: %s".formatted(message, cause.getClass().getName(), cause.getMessage());
        return constructor.apply(descriptiveMessage, cause);
    }

    public static void processException(Throwable e, DaemonUtils.Context context) {
        boolean unrecoverable = false;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause instanceof FileSystemUtil.UnrecoverableZipException) {
                unrecoverable = true;
                continue;
            }
            if (!(cause instanceof FileSystemException)) continue;
            FileSystemException fse = (FileSystemException)cause;
            ExceptionUtil.printFileLocks(fse.getFile());
            break;
        }
        if (unrecoverable) {
            DaemonUtils.tryStopGradleDaemon(context);
        }
    }

    private static void printFileLocks(String filename) {
        List processes;
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            processes = LoomNativePlatform.getProcessesWithLockOn((Path)path);
        }
        catch (LoomNativePlatformException e) {
            LOGGER.error("{}, Failed to query processes holding a lock on {}", (Object)e.getMessage(), (Object)path);
            return;
        }
        if (processes.isEmpty()) {
            return;
        }
        ProcessUtil processUtil = ProcessUtil.create(LOGGER.isInfoEnabled() ? ProcessUtil.ArgumentVisibility.SHOW_SENSITIVE : ProcessUtil.ArgumentVisibility.HIDE);
        String noun = processes.size() == 1 ? "process has" : "processes have";
        LOGGER.error("The following {} a lock on the file '{}':", (Object)noun, (Object)path);
        for (ProcessHandle process : processes) {
            LOGGER.error(processUtil.printWithParents(process));
        }
    }
}

