/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.mixin.AnnotationProcessorInvoker;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixinAPMappingService
extends Service<Options> {
    public static final ServiceType<Options, MixinAPMappingService> TYPE = new ServiceType<Options, MixinAPMappingService>(Options.class, MixinAPMappingService.class);
    private static final boolean USE_ALL_SOURCE_SETS = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinAPMappingService.class);
    private IMappingProvider mappingProvider = null;
    private boolean exists = true;

    public static Provider<List<Options>> createOptions(Project thisProject, Provider<String> from, Provider<String> to) {
        LoomGradleExtension thisExtension = LoomGradleExtension.get(thisProject);
        String mappingId = thisExtension.getMappingConfiguration().mappingsIdentifier;
        ArrayList providers = new ArrayList();
        Consumer<Project> processProject = project -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(project);
            for (SourceSet sourceSet : sourceSets) {
                LOGGER.debug("Creating MixinAPMappingService for source set: {}", (Object)sourceSet.getName());
                Provider<Options> provider = MixinAPMappingService.createOptions(thisProject, sourceSet, from, to);
                if (provider != null) {
                    providers.add(provider);
                    continue;
                }
                LOGGER.debug("Failed to create MixinAPMappingService for source set: {}", (Object)sourceSet.getName());
            }
        };
        if (thisExtension.isProjectIsolationActive()) {
            processProject.accept(thisProject);
        } else {
            GradleUtils.allLoomProjects(thisProject.getGradle(), project -> {
                if (project.getPlugins().hasPlugin("net.fabricmc.fabric-loom")) {
                    return;
                }
                LoomGradleExtension extension = LoomGradleExtension.get(project);
                if (!mappingId.equals(extension.getMappingConfiguration().mappingsIdentifier)) {
                    return;
                }
                processProject.accept((Project)project);
            });
        }
        return thisProject.provider(() -> providers.stream().map(Provider::get).toList());
    }

    public static @Nullable Provider<Options> createOptions(Project project, SourceSet sourceSet, Provider<String> from, Provider<String> to) {
        File mixinMappings = AnnotationProcessorInvoker.getMixinMappingsForSourceSet(project, sourceSet);
        Task compileTask = (Task)project.getTasks().findByName(sourceSet.getCompileJavaTaskName());
        if (compileTask == null) {
            return null;
        }
        boolean containsOutput = false;
        for (File file : compileTask.getOutputs().getFiles()) {
            if (!file.getName().equals(mixinMappings.getName())) continue;
            containsOutput = true;
            break;
        }
        if (!containsOutput) {
            LOGGER.warn("Failed to find mixin mappings {} in task outputs: {}", (Object)mixinMappings.getName(), (Object)compileTask.getOutputs().getFiles());
            return null;
        }
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            o.getCompileOutputs().from(new Object[]{compileTask.getOutputs()});
            o.getMixinMappingFileName().set((Object)mixinMappings.getName());
            o.getFrom().set(from);
            o.getTo().set(to);
        }));
    }

    public MixinAPMappingService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public @Nullable IMappingProvider getMappingsProvider() {
        if (!this.exists) {
            return null;
        }
        if (this.mappingProvider == null) {
            Path mappingsPath = this.getMappingsPath();
            if (!Files.exists(mappingsPath, new LinkOption[0])) {
                this.exists = false;
                return null;
            }
            try {
                this.mappingProvider = TinyRemapperHelper.create(mappingsPath, (String)((Options)this.getOptions()).getFrom().get(), (String)((Options)this.getOptions()).getTo().get(), false);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings from: " + String.valueOf(mappingsPath), e);
            }
        }
        return this.mappingProvider;
    }

    private Path getMappingsPath() {
        for (File file : ((Options)this.getOptions()).getCompileOutputs().getFiles()) {
            if (!file.getName().equals(((Options)this.getOptions()).getMixinMappingFileName().get())) continue;
            return file.toPath();
        }
        throw new RuntimeException("Failed to find mixin mappings file: " + (String)((Options)this.getOptions()).getMixinMappingFileName().get());
    }

    public static interface Options
    extends Service.Options {
        @InputFiles
        public ConfigurableFileCollection getCompileOutputs();

        @Input
        public Property<String> getMixinMappingFileName();

        @Input
        public Property<String> getFrom();

        @Input
        public Property<String> getTo();
    }
}

