/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class CompletableFutureCollector<X, T extends CompletableFuture<X>>
implements Collector<T, List<T>, CompletableFuture<List<X>>> {
    private CompletableFutureCollector() {
    }

    public static <X, T extends CompletableFuture<X>> Collector<T, List<T>, CompletableFuture<List<X>>> allOf() {
        return new CompletableFutureCollector<X, T>();
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<T>, CompletableFuture<List<X>>> finisher() {
        return ls -> CompletableFuture.allOf((CompletableFuture[])ls.toArray(CompletableFuture[]::new)).thenApply(v -> ls.stream().map(CompletableFuture::join).toList());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

