/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazyCloseable<T>
implements Closeable {
    private final Supplier<T> valueSupplier;
    private final Consumer<T> closeConsumer;
    private T value;

    public LazyCloseable(Supplier<T> valueSupplier, Consumer<T> closeConsumer) {
        this.valueSupplier = valueSupplier;
        this.closeConsumer = closeConsumer;
    }

    public T get() {
        if (this.value == null) {
            this.value = this.valueSupplier.get();
        }
        return this.value;
    }

    @Override
    public void close() throws IOException {
        if (this.value != null) {
            this.closeConsumer.accept(this.value);
            this.value = null;
        }
    }
}

