/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.AttributeHelper;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.Project;
import org.jspecify.annotations.Nullable;

public record BundleMetadata(List<Entry> libraries, List<Entry> versions, String mainClass) {
    private static final String LIBRARIES_LIST_PATH = "META-INF/libraries.list";
    private static final String VERSIONS_LIST_PATH = "META-INF/versions.list";
    private static final String MAINCLASS_PATH = "META-INF/main-class";

    public static @Nullable BundleMetadata fromJar(Path jar) throws IOException {
        String mainClass;
        List<Entry> versions;
        List<Entry> libraries;
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
            if (!Files.exists(fs.get().getPath(VERSIONS_LIST_PATH, new String[0]), new LinkOption[0])) {
                BundleMetadata bundleMetadata = null;
                return bundleMetadata;
            }
            libraries = BundleMetadata.readEntries(fs.readString(LIBRARIES_LIST_PATH), "META-INF/libraries/");
            versions = BundleMetadata.readEntries(fs.readString(VERSIONS_LIST_PATH), "META-INF/versions/");
            mainClass = fs.readString(MAINCLASS_PATH).trim();
        }
        return new BundleMetadata(libraries, versions, mainClass);
    }

    private static List<Entry> readEntries(String content, String pathPrefix) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String entry : content.split("\n")) {
            String[] split;
            if (entry.isBlank() || (split = entry.split("\t")).length != 3) continue;
            entries.add(new Entry(split[0], split[1], pathPrefix + split[2]));
        }
        return Collections.unmodifiableList(entries);
    }

    public record Entry(String sha1, String name, String path) {
        public void unpackEntry(Path jar, Path dest, Project project) throws IOException {
            String hash;
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (!extension.refreshDeps() && Files.exists(dest, new LinkOption[0]) && (hash = this.readHash(dest).orElse("")).equals(this.sha1)) {
                return;
            }
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
                Files.copy(fs.get().getPath(this.path(), new String[0]), dest, StandardCopyOption.REPLACE_EXISTING);
            }
            this.writeHash(dest, this.sha1);
        }

        private Optional<String> readHash(Path output) {
            try {
                return AttributeHelper.readAttribute(output, "LoomHash");
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }

        private void writeHash(Path output, String eTag) {
            try {
                AttributeHelper.writeAttribute(output, "LoomHash", eTag);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write hash to (%s)".formatted(output), e);
            }
        }
    }
}

