/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import net.fabricmc.loom.decompilers.ClassLineNumbers;
import net.fabricmc.loom.decompilers.cache.CachedFileStore;
import net.fabricmc.loom.decompilers.cache.RiffChunk;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CachedData(String className, String sources, @Nullable ClassLineNumbers.Entry lineNumbers) {
    public static final CachedFileStore.EntrySerializer<CachedData> SERIALIZER = new EntrySerializer();
    private static final String HEADER_ID = "LOOM";
    private static final String NAME_ID = "NAME";
    private static final String SOURCES_ID = "SRC ";
    private static final String LINE_NUMBERS_ID = "LNUM";
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedData.class);

    public CachedData {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(sources, "sources");
        if (lineNumbers != null && !className.equals(lineNumbers.className())) {
            throw new IllegalArgumentException("Class name does not match line numbers class name");
        }
    }

    public void write(FileChannel fileChannel) {
        try (RiffChunk c = new RiffChunk(HEADER_ID, fileChannel);){
            this.writeClassname(fileChannel);
            this.writeSource(fileChannel);
            if (this.lineNumbers != null) {
                this.writeLineNumbers(fileChannel);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write cached data", e);
        }
    }

    private void writeClassname(FileChannel fileChannel) throws IOException {
        try (RiffChunk c = new RiffChunk(NAME_ID, fileChannel);){
            fileChannel.write(ByteBuffer.wrap(this.className.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private void writeSource(FileChannel fileChannel) throws IOException {
        try (RiffChunk c = new RiffChunk(SOURCES_ID, fileChannel);){
            fileChannel.write(ByteBuffer.wrap(this.sources.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private void writeLineNumbers(FileChannel fileChannel) throws IOException {
        Objects.requireNonNull(this.lineNumbers);
        try (RiffChunk c = new RiffChunk(LINE_NUMBERS_ID, fileChannel);
             StringWriter stringWriter = new StringWriter();){
            this.lineNumbers.write(stringWriter);
            fileChannel.write(ByteBuffer.wrap(stringWriter.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static CachedData read(InputStream inputStream) throws IOException {
        String header = CachedData.readHeader(inputStream);
        if (!header.equals(HEADER_ID)) {
            throw new IOException("Invalid RIFF header: " + header + ", expected LOOM");
        }
        int length = CachedData.readInt(inputStream);
        String className = null;
        String sources = null;
        ClassLineNumbers.Entry lineNumbers = null;
        block15: while (inputStream.available() > 0) {
            String chunkHeader = CachedData.readHeader(inputStream);
            int chunkLength = CachedData.readInt(inputStream);
            byte[] chunkData = CachedData.readBytes(inputStream, chunkLength);
            switch (chunkHeader) {
                case "NAME": {
                    if (className != null) {
                        throw new IOException("Duplicate name chunk");
                    }
                    className = new String(chunkData, StandardCharsets.UTF_8);
                    break;
                }
                case "SRC ": {
                    if (sources != null) {
                        throw new IOException("Duplicate sources chunk");
                    }
                    sources = new String(chunkData, StandardCharsets.UTF_8);
                    break;
                }
                case "LNUM": {
                    if (lineNumbers != null) {
                        throw new IOException("Duplicate line numbers chunk");
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(chunkData), StandardCharsets.UTF_8));
                    try {
                        ClassLineNumbers classLineNumbers = ClassLineNumbers.readMappings(br);
                        if (classLineNumbers.lineMap().size() != 1) {
                            throw new IOException("Expected exactly one class line numbers entry got " + classLineNumbers.lineMap().size() + " entries");
                        }
                        lineNumbers = classLineNumbers.lineMap().values().iterator().next();
                        continue block15;
                    }
                    finally {
                        br.close();
                        continue block15;
                    }
                }
                default: {
                    LOGGER.warn("Skipping unknown chunk: {} of size {}", (Object)chunkHeader, (Object)chunkLength);
                    inputStream.skip(chunkLength);
                }
            }
        }
        if (sources == null) {
            throw new IOException("Missing sources");
        }
        return new CachedData(className, sources, lineNumbers);
    }

    private static String readHeader(InputStream inputStream) throws IOException {
        byte[] header = CachedData.readBytes(inputStream, 4);
        return new String(header, StandardCharsets.US_ASCII);
    }

    private static int readInt(InputStream inputStream) throws IOException {
        byte[] bytes = CachedData.readBytes(inputStream, 4);
        return ByteBuffer.wrap(bytes).getInt();
    }

    private static byte[] readBytes(InputStream inputStream, int length) throws IOException {
        byte[] bytes = new byte[length];
        int read = inputStream.read(bytes);
        if (read != length) {
            throw new IOException("Failed to read bytes expected " + length + " bytes but got " + read + " bytes");
        }
        return bytes;
    }

    static class EntrySerializer
    implements CachedFileStore.EntrySerializer<CachedData> {
        EntrySerializer() {
        }

        @Override
        public CachedData read(Path path) throws IOException {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                CachedData cachedData = CachedData.read(inputStream);
                return cachedData;
            }
        }

        @Override
        public void write(CachedData entry, Path path) throws IOException {
            try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                entry.write(fileChannel);
            }
        }
    }
}

