/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;

public interface ProjectView {
    public Stream<Project> getLoomProjectDependencies(String var1);

    public List<FabricModJson> getMods();

    public boolean disableProjectDependantMods();

    public boolean areEnvironmentSourceSetsSplit();

    public static abstract class AbstractProjectView
    implements ProjectView {
        protected final Project project;
        protected final LoomGradleExtension extension;

        protected AbstractProjectView(Project project) {
            this.project = project;
            this.extension = LoomGradleExtension.get(project);
        }

        @Override
        public Stream<Project> getLoomProjectDependencies(String name) {
            Configuration configuration = this.project.getConfigurations().getByName(name);
            return configuration.getAllDependencies().withType(ProjectDependency.class).stream().map(d -> this.project.project(d.getPath())).filter(GradleUtils::isLoomProject);
        }

        @Override
        public List<FabricModJson> getMods() {
            return FabricModJsonHelpers.getModsInProject(this.project);
        }

        @Override
        public boolean disableProjectDependantMods() {
            LoomGradleExtension extension = LoomGradleExtension.get(this.project);
            return extension.isProjectIsolationActive() || GradleUtils.getBooleanProperty(this.project, "fabric.loom.disableProjectDependentMods");
        }

        @Override
        public boolean areEnvironmentSourceSetsSplit() {
            return this.extension.areEnvironmentSourceSetsSplit();
        }
    }

    public static enum ArtifactUsage {
        RUNTIME("java-runtime"),
        COMPILE("java-api");

        private final String gradleUsage;

        private ArtifactUsage(String gradleUsage) {
            this.gradleUsage = gradleUsage;
        }

        public String getGradleUsage() {
            return this.gradleUsage;
        }
    }
}

