/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.loom.decompilers.cache.CachedFileStore;
import org.jspecify.annotations.Nullable;

public record CachedFileStoreImpl<T>(Path root, CachedFileStore.EntrySerializer<T> entrySerializer, CacheRules cacheRules) implements CachedFileStore<T>
{
    public CachedFileStoreImpl {
        Objects.requireNonNull(root, "root");
    }

    @Override
    public @Nullable T getEntry(String key) throws IOException {
        Path path = this.resolve(key);
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        return this.entrySerializer.read(path);
    }

    @Override
    public void putEntry(String key, T data) throws IOException {
        Path path = this.resolve(key);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        this.entrySerializer.write(data, path);
    }

    private Path resolve(String key) {
        return this.root.resolve(key);
    }

    public void prune() throws IOException {
        Object entry;
        Iterator<Object> iterator;
        ArrayList<PathEntry> entries = new ArrayList<PathEntry>();
        try (Stream<Path> walk = Files.walk(this.root, new FileVisitOption[0]);){
            iterator = walk.iterator();
            while (iterator.hasNext()) {
                entry = (Path)iterator.next();
                if (!Files.isRegularFile((Path)entry, new LinkOption[0])) continue;
                this.insertSorted(entries, new PathEntry((Path)entry));
            }
        }
        if ((long)entries.size() > this.cacheRules.maxFiles) {
            int i = 0;
            while ((long)i < this.cacheRules.maxFiles) {
                PathEntry toRemove = (PathEntry)entries.remove(0);
                Files.delete(toRemove.path);
                ++i;
            }
        }
        Instant maxAge = Instant.now().minus(this.cacheRules().maxAge());
        iterator = entries.iterator();
        while (iterator.hasNext() && !((PathEntry)(entry = (PathEntry)iterator.next())).lastModified().toInstant().isAfter(maxAge)) {
            iterator.remove();
            Files.delete(((PathEntry)entry).path);
        }
    }

    private void insertSorted(List<PathEntry> list, PathEntry entry) {
        int index = Collections.binarySearch(list, entry, Comparator.comparing(PathEntry::lastModified));
        if (index < 0) {
            index = -index - 1;
        }
        list.add(index, entry);
    }

    public record CacheRules(long maxFiles, Duration maxAge) {
    }

    record PathEntry(Path path, FileTime lastModified) {
        PathEntry(Path path) throws IOException {
            this(path, Files.getLastModifiedTime(path, new LinkOption[0]));
        }
    }
}

