/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api.mappings.layered.spec;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.configuration.providers.mappings.utils.DependencyFileSpec;
import net.fabricmc.loom.configuration.providers.mappings.utils.LocalFileSpec;
import net.fabricmc.loom.configuration.providers.mappings.utils.MavenFileSpec;
import net.fabricmc.loom.configuration.providers.mappings.utils.MinimalExternalModuleDependencyFileSpec;
import net.fabricmc.loom.configuration.providers.mappings.utils.URLFileSpec;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface FileSpec {
    public static FileSpec create(Object o) {
        Objects.requireNonNull(o, "Object cannot be null");
        if (o instanceof CharSequence) {
            CharSequence s = (CharSequence)o;
            if (s.toString().startsWith("https://") || s.toString().startsWith("http://")) {
                try {
                    return FileSpec.create(new URL(s.toString()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to convert string to URL", e);
                }
            }
            return FileSpec.createFromMavenDependency(s.toString());
        }
        if (o instanceof MinimalExternalModuleDependency) {
            MinimalExternalModuleDependency d = (MinimalExternalModuleDependency)o;
            return FileSpec.createFromMinimalExternalModuleDependency(d);
        }
        if (o instanceof Dependency) {
            Dependency d = (Dependency)o;
            return FileSpec.createFromDependency(d);
        }
        if (o instanceof Provider) {
            Provider p = (Provider)o;
            return FileSpec.create(p.get());
        }
        if (o instanceof File) {
            File f = (File)o;
            return FileSpec.createFromFile(f);
        }
        if (o instanceof Path) {
            Path p = (Path)o;
            return FileSpec.createFromFile(p);
        }
        if (o instanceof FileSystemLocation) {
            FileSystemLocation l = (FileSystemLocation)o;
            return FileSpec.createFromFile(l);
        }
        if (o instanceof URL) {
            URL url = (URL)o;
            return FileSpec.createFromUrl(url);
        }
        if (o instanceof FileSpec) {
            FileSpec s = (FileSpec)o;
            return s;
        }
        throw new UnsupportedOperationException("Cannot create FileSpec from object of type:" + o.getClass().getCanonicalName());
    }

    public static FileSpec createFromMavenDependency(String dependencyNotation) {
        return new MavenFileSpec(dependencyNotation);
    }

    public static FileSpec createFromDependency(Dependency dependency) {
        return new DependencyFileSpec(dependency);
    }

    public static FileSpec createFromFile(File file) {
        return new LocalFileSpec(file);
    }

    public static FileSpec createFromFile(FileSystemLocation location) {
        return FileSpec.createFromFile(location.getAsFile());
    }

    public static FileSpec createFromFile(Path path) {
        return FileSpec.createFromFile(path.toFile());
    }

    public static FileSpec createFromUrl(URL url) {
        return new URLFileSpec(url.toString());
    }

    public static FileSpec createFromFile(RegularFileProperty regularFileProperty) {
        return FileSpec.createFromFile((FileSystemLocation)regularFileProperty.get());
    }

    public static FileSpec createFromMinimalExternalModuleDependency(MinimalExternalModuleDependency externalModuleDependency) {
        return new MinimalExternalModuleDependencyFileSpec(externalModuleDependency);
    }

    public Path get(MappingContext var1);
}

