/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.file;

import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.FileMappingsSpecBuilder;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import net.fabricmc.loom.configuration.providers.mappings.file.FileMappingsSpec;
import net.fabricmc.loom.configuration.providers.mappings.utils.MavenFileSpec;

public class FileMappingsSpecBuilderImpl
implements FileMappingsSpecBuilder {
    private static final String DEFAULT_MAPPING_PATH = "mappings/mappings.tiny";
    private final FileSpec fileSpec;
    private String mappingPath = "mappings/mappings.tiny";
    private Optional<String> fallbackSourceNamespace = Optional.empty();
    private String fallbackTargetNamespace = MappingsNamespace.NAMED.toString();
    private boolean enigma = false;
    private boolean unpick = false;
    private boolean annotations = false;
    private Optional<String> mergeNamespace = Optional.empty();
    private Optional<String> fallbackUnpickConstants = Optional.empty();

    private FileMappingsSpecBuilderImpl(FileSpec fileSpec) {
        this.fileSpec = fileSpec;
    }

    public static FileMappingsSpecBuilderImpl builder(FileSpec fileSpec) {
        return new FileMappingsSpecBuilderImpl(fileSpec);
    }

    @Override
    public FileMappingsSpecBuilderImpl mappingPath(String mappingPath) {
        this.mappingPath = Objects.requireNonNull(mappingPath, "mapping path cannot be null");
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl fallbackNamespaces(String sourceNamespace, String targetNamespace) {
        this.fallbackSourceNamespace = Optional.of(Objects.requireNonNull(sourceNamespace, "fallback source namespace cannot be null"));
        this.fallbackTargetNamespace = Objects.requireNonNull(targetNamespace, "fallback target namespace cannot be null");
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl enigmaMappings() {
        this.enigma = true;
        return this;
    }

    @Override
    public FileMappingsSpecBuilder containsAnnotations() {
        this.annotations = true;
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl containsUnpick() {
        this.unpick = true;
        FileSpec fileSpec = this.fileSpec;
        if (fileSpec instanceof MavenFileSpec) {
            MavenFileSpec mavenFileSpec = (MavenFileSpec)fileSpec;
            String dependencyNotation = mavenFileSpec.dependencyNotation();
            String[] notationParts = dependencyNotation.split(":");
            if (notationParts.length == 4) {
                dependencyNotation = dependencyNotation.substring(0, dependencyNotation.lastIndexOf(58));
            }
            this.fallbackUnpickConstants = Optional.of(dependencyNotation + ":constants");
        }
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl mergeNamespace(MappingsNamespace namespace) {
        this.mergeNamespace = Optional.of(Objects.requireNonNull(namespace, "merge namespace cannot be null").toString());
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl mergeNamespace(String namespace) {
        Objects.requireNonNull(namespace, "merge namespace cannot be null");
        if (MappingsNamespace.of(namespace) == null) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' is unsupported! It must be either 'official', 'intermediary' or 'named'.");
        }
        this.mergeNamespace = Optional.of(namespace);
        return this;
    }

    public FileMappingsSpec build() {
        return new FileMappingsSpec(this.fileSpec, this.mappingPath, this.fallbackSourceNamespace, this.fallbackTargetNamespace, this.enigma, this.unpick, this.annotations, this.mergeNamespace, this.fallbackUnpickConstants);
    }
}

