/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.lang.reflect.Method;
import java.util.function.Function;
import net.fabricmc.loom.util.service.Service;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;

public record ServiceType<O extends Service.Options, S extends Service<O>>(Class<O> optionsClass, Class<S> serviceClass) {
    public Provider<O> create(Project project, Action<O> action) {
        return this.maybeCreate(project, o -> {
            action.execute(o);
            return true;
        });
    }

    public Provider<O> maybeCreate(Project project, Function<O, Boolean> function) {
        return project.provider(() -> {
            Service.Options options = (Service.Options)project.getObjects().newInstance(this.optionsClass, new Object[0]);
            for (Method method : this.optionsClass.getDeclaredMethods()) {
                method.invoke((Object)options, new Object[0]);
            }
            options.getServiceClass().set((Object)this.serviceClass.getName());
            options.getServiceClass().finalizeValue();
            if (((Boolean)function.apply(options)).booleanValue()) {
                return options;
            }
            return null;
        });
    }
}

