/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.fabricmc.loom.util.IOFunction;
import net.fabricmc.tinyremapper.FileSystemReference;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    public static Delegate getJarFileSystem(File file, boolean create) throws IOException {
        return new Delegate(FileSystemReference.openJar((Path)file.toPath(), (boolean)create), FileSystemUtil.toJarUri(file.toPath()));
    }

    public static Delegate getJarFileSystem(Path path, boolean create) throws IOException {
        return new Delegate(FileSystemReference.openJar((Path)path, (boolean)create), FileSystemUtil.toJarUri(path));
    }

    public static Delegate getJarFileSystem(Path path) throws IOException {
        return new Delegate(FileSystemReference.openJar((Path)path), FileSystemUtil.toJarUri(path));
    }

    public static Delegate getJarFileSystem(URI uri, boolean create) throws IOException {
        return new Delegate(FileSystemReference.open((URI)uri, (boolean)create), uri);
    }

    private static URI toJarUri(Path path) {
        URI uri = path.toUri();
        try {
            return new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("can't convert path " + String.valueOf(path) + " to uri", e);
        }
    }

    public record Delegate(FileSystemReference reference, URI uri) implements AutoCloseable,
    Supplier<FileSystem>
    {
        public Path getPath(String path, String ... more) {
            return this.get().getPath(path, more);
        }

        public Path getRoot() {
            return this.get().getPath("/", new String[0]);
        }

        public byte[] readAllBytes(String path) throws IOException {
            Path fsPath = this.getPath(path, new String[0]);
            if (Files.exists(fsPath, new LinkOption[0])) {
                return Files.readAllBytes(fsPath);
            }
            throw new NoSuchFileException(fsPath.toString());
        }

        public <T> T fromInputStream(IOFunction<InputStream, T> function, String path, String ... more) throws IOException {
            try (InputStream inputStream = Files.newInputStream(this.getPath(path, more), new OpenOption[0]);){
                T t = function.apply(inputStream);
                return t;
            }
        }

        public String readString(String path) throws IOException {
            return new String(this.readAllBytes(path), StandardCharsets.UTF_8);
        }

        @Override
        public void close() throws IOException {
            try {
                this.reference.close();
            }
            catch (IOException e) {
                try {
                    FileSystem fileSystem = FileSystems.getFileSystem(this.uri);
                    if (fileSystem.isOpen()) {
                        throw e;
                    }
                    throw new UnrecoverableZipException(e.getMessage(), e);
                }
                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                    throw e;
                }
            }
        }

        @Override
        public FileSystem get() {
            return this.reference.getFs();
        }

        public FileSystem fs() {
            return this.get();
        }
    }

    public static class UnrecoverableZipException
    extends RuntimeException {
        public UnrecoverableZipException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

