/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.net.URISyntaxException;
import java.time.Duration;
import javax.inject.Inject;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.download.DownloadException;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.ApiStatus;

@DisableCachingByDefault
public abstract class DownloadTask
extends DefaultTask {
    @Input
    public abstract Property<String> getUrl();

    @Optional
    @Input
    public abstract Property<String> getSha1();

    @Optional
    @Input
    public abstract Property<Duration> getMaxAge();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    @ApiStatus.Internal
    protected abstract Property<Boolean> getIsOffline();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public DownloadTask() {
        this.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(DownloadAction.class, params -> {
            params.getUrl().set(this.getUrl());
            params.getSha1().set(this.getSha1());
            params.getMaxAge().set(this.getMaxAge());
            params.getOutputFile().set((Provider)this.getOutput());
            params.getIsOffline().set(this.getIsOffline());
        });
    }

    public static abstract class DownloadAction
    implements WorkAction<DownloadWorkParameters> {
        public void execute() {
            DownloadBuilder builder;
            try {
                builder = Download.create((String)((DownloadWorkParameters)this.getParameters()).getUrl().get()).defaultCache();
            }
            catch (URISyntaxException e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Invalid URL", e);
            }
            if (((DownloadWorkParameters)this.getParameters()).getMaxAge().isPresent()) {
                builder.maxAge((Duration)((DownloadWorkParameters)this.getParameters()).getMaxAge().get());
            }
            if (((DownloadWorkParameters)this.getParameters()).getSha1().isPresent()) {
                builder.sha1((String)((DownloadWorkParameters)this.getParameters()).getSha1().get());
            }
            if (((Boolean)((DownloadWorkParameters)this.getParameters()).getIsOffline().get()).booleanValue()) {
                builder.offline();
            }
            try {
                builder.downloadPath(((RegularFile)((DownloadWorkParameters)this.getParameters()).getOutputFile().get()).getAsFile().toPath());
            }
            catch (DownloadException e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to download file", e);
            }
        }
    }

    public static interface DownloadWorkParameters
    extends WorkParameters {
        public Property<String> getUrl();

        public Property<String> getSha1();

        public Property<Duration> getMaxAge();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getIsOffline();
    }
}

