/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jspecify.annotations.Nullable;

public final class TinyMappingsService
extends Service<Options> {
    public static final ServiceType<Options, TinyMappingsService> TYPE = new ServiceType<Options, TinyMappingsService>(Options.class, TinyMappingsService.class);
    private final Supplier<MemoryMappingTree> mappingTree = Lazy.of(() -> {
        Path mappings = ((Options)this.getOptions()).getMappings().getSingleFile().toPath();
        if (((Options)this.getOptions()).getZipEntryPath().isPresent()) {
            MemoryMappingTree memoryMappingTree;
            block9: {
                FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(mappings);
                try {
                    memoryMappingTree = this.readMappings(delegate.fs().getPath((String)((Options)this.getOptions()).getZipEntryPath().get(), new String[0]));
                    if (delegate == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (delegate != null) {
                            try {
                                delegate.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to read mappings from zip", e);
                    }
                }
                delegate.close();
            }
            return memoryMappingTree;
        }
        return this.readMappings(mappings);
    });

    public static Provider<Options> createOptions(Project project, Path mappings) {
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            options.getMappings().from(new Object[]{project.file((Object)mappings)});
            options.getZipEntryPath().unset();
        }));
    }

    public static Provider<Options> createOptions(Project project, FileCollection mappings, @Nullable String zipEntryPath) {
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            options.getMappings().from(new Object[]{mappings});
            options.getZipEntryPath().set((Object)zipEntryPath);
        }));
    }

    public TinyMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    private MemoryMappingTree readMappings(Path mappings) {
        try {
            MemoryMappingTree mappingTree = new MemoryMappingTree();
            MappingReader.read((Path)mappings, (MappingVisitor)mappingTree);
            return mappingTree;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read mappings", e);
        }
    }

    public MemoryMappingTree getMappingTree() {
        return this.mappingTree.get();
    }

    public static interface Options
    extends Service.Options {
        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        public ConfigurableFileCollection getMappings();

        @Optional
        @Input
        public Property<String> getZipEntryPath();
    }
}

