/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library;

import java.util.Arrays;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.JavaVersion;

public final class LibraryContext {
    private final MinecraftVersionMeta versionMeta;
    private final JavaVersion javaVersion;

    public LibraryContext(MinecraftVersionMeta versionMeta, JavaVersion javaVersion) {
        this.versionMeta = versionMeta;
        this.javaVersion = javaVersion;
    }

    public boolean supportsArm64(Platform.OperatingSystem operatingSystem) {
        String osName = switch (operatingSystem) {
            default -> throw new MatchException(null, null);
            case Platform.OperatingSystem.MAC_OS -> "macos";
            case Platform.OperatingSystem.WINDOWS -> "windows";
            case Platform.OperatingSystem.LINUX -> "linux";
        };
        return this.versionMeta.libraries().stream().anyMatch(library -> library.name().startsWith("org.lwjgl:lwjgl:3") && library.name().endsWith(":natives-%s-arm64".formatted(osName)));
    }

    public boolean supportsJava19OrLater() {
        return this.versionMeta.libraries().stream().filter(library -> library.name().startsWith("org.lwjgl:lwjgl:")).anyMatch(library -> {
            String[] split = library.name().split(":");
            if (split.length != 3) {
                return false;
            }
            String version = split[2];
            int[] versionSplit = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
            if (versionSplit[0] > 3) {
                return true;
            }
            if (versionSplit[0] == 3 && versionSplit[1] > 3) {
                return true;
            }
            return versionSplit[0] == 3 && versionSplit[1] == 3 && versionSplit[2] >= 2;
        });
    }

    public boolean usesLWJGL3() {
        return this.versionMeta.libraries().stream().anyMatch(library -> library.name().startsWith("org.lwjgl:lwjgl:3"));
    }

    public boolean hasClasspathNatives() {
        return !this.versionMeta.hasNativesToExtract();
    }

    public boolean hasLibrary(String name) {
        return this.versionMeta.libraries().stream().anyMatch(library -> library.name().equals(name));
    }

    public boolean isJava19OrLater() {
        return this.javaVersion.isCompatibleWith(JavaVersion.VERSION_19);
    }
}

