/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.classpathgroups.ClasspathGroup;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroup;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroupDTO;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public class ClasspathGroupService
extends Service<Options> {
    public static ServiceType<Options, ClasspathGroupService> TYPE = new ServiceType<Options, ClasspathGroupService>(Options.class, ClasspathGroupService.class);
    private final Supplier<Map<String, ExternalClasspathGroupDTO>> externalClasspathGroups = Lazy.of(() -> ExternalClasspathGroupDTO.resolveExternal(((Options)this.getOptions()).getExternalClasspathGroups().getFiles()));

    public static Provider<Options> create(Project project) {
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            NamedDomainObjectContainer<ModSettings> modSettings = extension.getMods();
            if (modSettings.isEmpty()) {
                return;
            }
            options.getClasspathGroups().set(ClasspathGroup.fromModSettings(modSettings));
            if (!ClasspathGroupService.hasExternalClasspathGroups(modSettings)) {
                return;
            }
            List<Dependency> externalDependencies = ClasspathGroupService.getExternalDependencies(project, modSettings);
            Configuration externalClasspathGroups = project.getConfigurations().detachedConfiguration(externalDependencies.toArray(new Dependency[0]));
            options.getExternalClasspathGroups().from(new Object[]{externalClasspathGroups});
        }));
    }

    private static boolean hasExternalClasspathGroups(Set<ModSettings> modSettings) {
        return modSettings.stream().anyMatch(s -> s.getExternalGroups().isPresent() && !((List)s.getExternalGroups().get()).isEmpty());
    }

    private static List<Dependency> getExternalDependencies(Project project, Set<ModSettings> modSettings) {
        List<String> requiredProjects = modSettings.stream().flatMap(s -> ((List)s.getExternalGroups().get()).stream()).map(ExternalClasspathGroup::projectPath).distinct().toList();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String projectPath : requiredProjects) {
            Dependency externalDependency = project.getDependencies().project(Map.of("path", projectPath, "configuration", "loomExportedClasspath"));
            dependencies.add(externalDependency);
        }
        return Collections.unmodifiableList(dependencies);
    }

    public ClasspathGroupService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public List<File> getClasspath(ClasspathGroup classpathGroup) {
        ArrayList<String> paths = new ArrayList<String>();
        for (ExternalClasspathGroup externalGroup : classpathGroup.externalGroups()) {
            ExternalClasspathGroupDTO dto = this.externalClasspathGroups.get().get(externalGroup.projectPath());
            if (dto == null) {
                throw new IllegalStateException("Could not find resolved external classpath group for project: " + externalGroup.projectPath());
            }
            paths.addAll(dto.getForSourceSet(externalGroup.sourceSetName()));
        }
        paths.addAll(classpathGroup.paths());
        return paths.stream().map(File::new).toList();
    }

    public String getClasspathGroupsPropertyValue() {
        return ((List)((Options)this.getOptions()).getClasspathGroups().get()).stream().map(group -> this.getClasspath((ClasspathGroup)group).stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator))).collect(Collectors.joining(File.pathSeparator + File.pathSeparator));
    }

    public boolean hasGroups() {
        return ((Options)this.getOptions()).getClasspathGroups().isPresent() && !((List)((Options)this.getOptions()).getClasspathGroups().get()).isEmpty();
    }

    public static interface Options
    extends Service.Options {
        @Input
        @Optional
        public ListProperty<ClasspathGroup> getClasspathGroups();

        @InputFiles
        @Optional
        @PathSensitive(value=PathSensitivity.NONE)
        public ConfigurableFileCollection getExternalClasspathGroups();
    }
}

