/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.task.AbstractMigrateMappingsTask;
import net.fabricmc.loom.task.service.MigrateSourceCodeMappingsService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;

@UntrackedTask(because="Always rerun this task.")
public abstract class MigrateMappingsTask
extends AbstractMigrateMappingsTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @SkipWhenEmpty
    @Option(option="input", description="Java source file directory")
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    @Option(option="output", description="Remapped source output directory")
    public abstract DirectoryProperty getOutputDir();

    @Nested
    protected abstract Property<MigrateSourceCodeMappingsService.Options> getMigrationServiceOptions();

    public MigrateMappingsTask() {
        this.getInputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("src/main/java"));
        this.getOutputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("remappedSrc"));
        this.getMigrationServiceOptions().set(MigrateSourceCodeMappingsService.createOptions(this.getProject(), this.getMappings(), this.getInputDir(), this.getOutputDir()));
    }

    @TaskAction
    public void doTask() throws Throwable {
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            MigrateSourceCodeMappingsService service = (MigrateSourceCodeMappingsService)serviceFactory.get((MigrateSourceCodeMappingsService.Options)this.getMigrationServiceOptions().get());
            service.migrateMappings();
        }
        if (((Boolean)this.getOverrideInputs().get()).booleanValue()) {
            Path inputPath = ((File)this.getInputDir().getAsFile().get()).toPath();
            Path outputPath = ((File)this.getOutputDir().getAsFile().get()).toPath();
            DeletingFileVisitor.deleteDirectory(inputPath);
            Files.move(outputPath, inputPath, new CopyOption[0]);
        }
    }
}

