/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.fabricmc.loom.util.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ClassEntry(String name, List<String> innerClasses, List<String> superClasses) {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassEntry.class);

    public ClassEntry {
        if (!name.endsWith(".class")) {
            throw new IllegalArgumentException("Class name must end with '.class': " + name);
        }
        if (!name.contains("/")) {
            throw new IllegalArgumentException("Class name must be in a package: " + name);
        }
        String className = name.replace(".class", "");
        for (String innerClass : innerClasses) {
            if (!innerClass.endsWith(".class")) {
                throw new IllegalArgumentException("Inner class name must end with '.class': " + name);
            }
            if (innerClass.startsWith(className)) continue;
            throw new IllegalArgumentException("Inner class (" + innerClass + ") does not have the parent class name as a prefix: " + name);
        }
        for (String superClass : superClasses) {
            if (superClass.endsWith(".class")) continue;
            throw new IllegalArgumentException("Super class name must end with '.class': " + superClass);
        }
    }

    public void copyTo(Path sourceRoot, Path targetRoot) throws IOException {
        Path targetPath = targetRoot.resolve(this.name);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        this.copy(sourceRoot.resolve(this.name), targetPath);
        for (String innerClass : this.innerClasses) {
            this.copy(sourceRoot.resolve(innerClass), targetRoot.resolve(innerClass));
        }
    }

    private void copy(Path source, Path target) throws IOException {
        LOGGER.debug("Copying class entry `{}` from `{}` to `{}`", new Object[]{this.name, source, target});
        Files.copy(source, target, new CopyOption[0]);
    }

    public String hash(Path root) throws IOException {
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(Checksum.of(root.resolve(this.name)).sha256().hex());
        for (String innerClass : this.innerClasses) {
            joiner.add(Checksum.of(root.resolve(innerClass)).sha256().hex());
        }
        return Checksum.of(joiner.toString()).sha256().hex();
    }

    public String hashSuperHierarchy(Map<String, String> hashes) throws IOException {
        String selfHash = Objects.requireNonNull(hashes.get(this.name), "Hash for own class not found");
        if (this.superClasses.isEmpty()) {
            return selfHash;
        }
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(selfHash);
        for (String superClass : this.superClasses) {
            String superHash = hashes.get(superClass);
            if (superHash != null) {
                joiner.add(superHash);
                continue;
            }
            if (superClass.startsWith("java/")) continue;
            LOGGER.debug("Hash for super class {} of {} not found", (Object)superClass, (Object)this.name);
        }
        return Checksum.of(joiner.toString()).sha256().hex();
    }

    public String sourcesFileName() {
        return this.name.replace(".class", ".java");
    }
}

