/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import org.gradle.api.tasks.Sync;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class ExtractNativesTask
extends Sync {
    @Inject
    public ExtractNativesTask() {
        for (File nativeFile : this.getProject().getConfigurations().getByName("minecraftNatives").getFiles()) {
            this.from(this.getProject().zipTree((Object)nativeFile), copySpec -> {
                copySpec.exclude(new String[]{"META-INF/**"});
                copySpec.rename(s -> s.replace(".jnilib", ".dylib"));
            });
        }
        this.into(LoomGradleExtension.get(this.getProject()).getFiles().getNativesDirectory(this.getProject()));
        this.setDescription("Downloads and extracts the minecraft natives");
    }
}

