/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class GenEclipseRunsTask
extends AbstractLoomTask {
    @Nested
    protected abstract ListProperty<EclipseRunConfig> getEclipseRunConfigs();

    @Inject
    public GenEclipseRunsTask() {
        this.setGroup("ide");
        this.getEclipseRunConfigs().set(this.getProject().provider(() -> GenEclipseRunsTask.getRunConfigs(this.getProject())));
    }

    @TaskAction
    public void genRuns() throws IOException {
        for (EclipseRunConfig runConfig : (List)this.getEclipseRunConfigs().get()) {
            runConfig.writeLaunchFile();
        }
    }

    private static List<EclipseRunConfig> getRunConfigs(Project project) {
        EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<EclipseRunConfig> runConfigs = new ArrayList<EclipseRunConfig>();
        for (RunConfigSettings settings : extension.getRunConfigs()) {
            String config;
            if (!settings.isIdeConfigGenerated()) continue;
            String name = settings.getName();
            File configs = new File(project.getProjectDir(), eclipseModel.getProject().getName() + "_" + name + ".launch");
            RunConfig configInst = RunConfig.runConfig(project, settings);
            try {
                config = configInst.fromDummy("eclipse_run_config_template.xml", false, project);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to generate Eclipse run configuration", e);
            }
            EclipseRunConfig eclipseRunConfig = (EclipseRunConfig)project.getObjects().newInstance(EclipseRunConfig.class, new Object[0]);
            eclipseRunConfig.getLaunchContent().set((Object)config);
            eclipseRunConfig.getLaunchFile().set(project.file((Object)configs));
            runConfigs.add(eclipseRunConfig);
            settings.makeRunDir();
        }
        return runConfigs;
    }

    public static interface EclipseRunConfig {
        @Input
        public Property<String> getLaunchContent();

        @OutputFile
        public RegularFileProperty getLaunchFile();

        default public void writeLaunchFile() throws IOException {
            Path launchFile = ((RegularFile)this.getLaunchFile().get()).getAsFile().toPath();
            if (Files.notExists(launchFile, new LinkOption[0])) {
                Files.writeString(launchFile, (CharSequence)this.getLaunchContent().get(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }
}

