/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.ClassTweakerWriter;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.visitors.ClassTweakerRemapperVisitor;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.task.AbstractMigrateMappingsTask;
import net.fabricmc.loom.task.service.MigrateClassTweakerMappingsService;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;

@UntrackedTask(because="Always rerun this task.")
public abstract class MigrateClassTweakerMappingsTask
extends AbstractMigrateMappingsTask {
    @InputFile
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.NONE)
    @Option(option="input", description="Access widener file")
    public abstract RegularFileProperty getInputFile();

    @OutputFile
    @Option(option="output", description="Remapped access widener file")
    public abstract RegularFileProperty getOutputFile();

    @Nested
    protected abstract Property<MigrateClassTweakerMappingsService.Options> getMigrationServiceOptions();

    public MigrateClassTweakerMappingsTask() {
        this.getInputFile().convention((Provider)this.getExtension().getAccessWidenerPath());
        this.getOutputFile().convention(this.getProject().getLayout().getProjectDirectory().file("remapped.accesswidener"));
        this.getMigrationServiceOptions().set(MigrateClassTweakerMappingsService.createOptions(this.getProject(), this.getMappings()));
    }

    @TaskAction
    public void doTask() throws Throwable {
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            MigrateClassTweakerMappingsService service = (MigrateClassTweakerMappingsService)serviceFactory.get((MigrateClassTweakerMappingsService.Options)this.getMigrationServiceOptions().get());
            Path inputFile = ((RegularFile)this.getInputFile().get()).getAsFile().toPath();
            byte[] inputBytes = Files.readAllBytes(inputFile);
            int ctVersion = ClassTweakerReader.readVersion((byte[])inputBytes);
            ClassTweakerWriter writer = ClassTweakerWriter.create((int)ctVersion);
            ClassTweakerRemapperVisitor remapper = new ClassTweakerRemapperVisitor((ClassTweakerVisitor)writer, service.getRemapper(), MappingsNamespace.NAMED.toString(), MappingsNamespace.NAMED.toString());
            ClassTweakerReader.create((ClassTweakerVisitor)remapper).read(inputBytes, "unused_id");
            boolean inPlace = (Boolean)this.getOverrideInputs().get();
            Path targetFile = inPlace ? inputFile : ((RegularFile)this.getOutputFile().get()).getAsFile().toPath();
            Files.write(targetFile, writer.getOutput(), new OpenOption[0]);
        }
    }
}

