/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.prod;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.fabricmc.loom.util.ExceptionUtil;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TracyCapture {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracyCapture.class);

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract RegularFileProperty getTracyCapture();

    @Input
    public abstract Property<Integer> getMaxShutdownWaitSeconds();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getOutput();

    @Inject
    public TracyCapture() {
        this.getMaxShutdownWaitSeconds().convention((Object)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithTracy(IORunnable runnable) throws IOException {
        TracyCaptureRunner tracyCaptureRunner = this.createRunner();
        boolean success = false;
        try {
            runnable.run();
            success = true;
        }
        finally {
            block8: {
                try {
                    tracyCaptureRunner.close();
                }
                catch (Exception e) {
                    if (!success) break block8;
                    throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to stop tracy capture", e);
                }
            }
        }
    }

    private TracyCaptureRunner createRunner() throws IOException {
        File tracyCapture = (File)this.getTracyCapture().getAsFile().get();
        File output = (File)this.getOutput().getAsFile().get();
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(tracyCapture.getAbsolutePath(), "-a", "127.0.0.1", "-f", "-o", output.getAbsolutePath());
        Process process = builder.start();
        TracyCapture.captureLog(process.getInputStream(), arg_0 -> ((Logger)LOGGER).info(arg_0));
        TracyCapture.captureLog(process.getErrorStream(), arg_0 -> ((Logger)LOGGER).error(arg_0));
        LOGGER.info("Tracy capture started");
        return new TracyCaptureRunner(process, (Integer)this.getMaxShutdownWaitSeconds().get());
    }

    private static void captureLog(InputStream inputStream, Consumer<String> lineConsumer) {
        new Thread(() -> {
            try {
                new BufferedReader(new InputStreamReader(inputStream)).lines().forEach(lineConsumer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    private record TracyCaptureRunner(Process process, int shutdownWait) implements AutoCloseable
    {
        @Override
        public void close() throws Exception {
            int exitCode;
            for (int i = 0; i < this.shutdownWait && this.process.isAlive(); ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.process.isAlive()) {
                LOGGER.error("Tracy capture did not stop on its own, killing it");
                this.process.destroy();
                this.process.waitFor();
            }
            if ((exitCode = this.process.exitValue()) != 0) {
                throw new RuntimeException("Tracy capture failed with exit code " + exitCode);
            }
        }
    }

    @FunctionalInterface
    public static interface IORunnable {
        public void run() throws IOException;
    }
}

