/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.tool;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomProblems;
import net.fabricmc.mappingio.FlatMappingVisitor;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.FlatAsRegularMappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@DisableCachingByDefault
public abstract class ValidateModProvidedJavadocTask
extends AbstractLoomTask {
    private static final ProblemId MAPPINGS_CONTAIN_DST_NAMES = LoomProblems.problemId("mappings-contain-dst-names", "Mod-provided javadoc mapping file contains renames");
    private static final ProblemId INCORRECT_MAPPING_SRC_NAME = LoomProblems.problemId("incorrect-mapping-src-name", "Mod-provided javadoc mapping file has an invalid source namespace");
    private static final ProblemId MAPPING_PARSING_ERROR = LoomProblems.problemId("mapping-parsing-error", "Cannot parse mod-provided javadoc mapping file");
    private static final ProblemId CODE_ELEMENT_MISSING = LoomProblems.problemId("code-element-missing", "Cannot find code element to document");

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getMappingFiles();

    @Classpath
    public abstract ConfigurableFileCollection getMinecraftJars();

    @Input
    public abstract Property<String> getExpectedNamespace();

    @Inject
    @ApiStatus.Internal
    protected abstract Problems getProblems();

    public ValidateModProvidedJavadocTask() {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.getExtension().getProductionNamespaceEnum().map(this.getExtension()::getMinecraftJarsCollection);
        this.getMinecraftJars().convention(objectArray);
        this.getExpectedNamespace().convention(this.getExtension().getProductionNamespace());
        this.getOutputs().upToDateWhen(task -> true);
    }

    @TaskAction
    protected void check() throws IOException {
        try (Validator validator = new Validator(this::reportError, this.getMinecraftJars().getFiles());){
            for (File mappingFile : this.getMappingFiles()) {
                validator.check(mappingFile.toPath(), (String)this.getExpectedNamespace().get());
            }
        }
    }

    private void reportError(ProblemId problemId, Path currentPath, @Nullable String details, @Nullable Exception cause) throws IOException {
        ProblemReporter reporter = this.getProblems().getReporter();
        String message = details != null ? details : problemId.getDisplayName();
        reporter.throwing((Throwable)new IOException(message, cause), problemId, spec -> {
            spec.fileLocation(currentPath.toAbsolutePath().toString());
            if (details != null) {
                spec.details(details);
            }
            if (cause != null) {
                spec.withException((Throwable)cause);
            }
        });
    }

    @VisibleForTesting
    public static final class Validator
    implements Closeable {
        private final ErrorReporter errorReporter;
        private final GameJarIndex jarIndex;

        public Validator(ErrorReporter errorReporter, Collection<File> targetJars) throws IOException {
            this.errorReporter = errorReporter;
            this.jarIndex = new GameJarIndex(targetJars);
        }

        public void check(Path mappingFile, String expectedNamespace) throws IOException {
            try {
                StructuralChecker structuralChecker = new StructuralChecker(this.jarIndex, this.errorReporter, mappingFile);
                MappingChecker visitor = new MappingChecker((MappingVisitor)new FlatAsRegularMappingVisitor((FlatMappingVisitor)structuralChecker), expectedNamespace, this.errorReporter, mappingFile);
                MappingReader.read((Path)mappingFile, (MappingVisitor)visitor);
            }
            catch (IOException e) {
                this.errorReporter.reportError(MAPPING_PARSING_ERROR, mappingFile, "Cannot parse mappings, " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            this.jarIndex.close();
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface ErrorReporter {
        public void reportError(ProblemId var1, Path var2, @Nullable String var3, @Nullable Exception var4) throws IOException;

        default public void reportError(ProblemId problemId, Path currentPath, @Nullable String details) throws IOException {
            this.reportError(problemId, currentPath, details, null);
        }
    }

    private static final class StructuralChecker
    implements FlatMappingVisitor {
        private final GameJarIndex jarIndex;
        private final ErrorReporter errorReporter;
        private final Path currentPath;

        private StructuralChecker(GameJarIndex jarIndex, ErrorReporter errorReporter, Path currentPath) {
            this.jarIndex = jarIndex;
            this.errorReporter = errorReporter;
            this.currentPath = currentPath;
        }

        public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) {
        }

        public boolean visitClass(String srcName, @Nullable String @Nullable [] dstNames) {
            return true;
        }

        public void visitClassComment(String srcName, @Nullable String @Nullable [] dstNames, String comment) throws IOException {
            if (!this.jarIndex.classExists(srcName)) {
                this.errorReporter.reportError(CODE_ELEMENT_MISSING, this.currentPath, "Class " + srcName + " does not exist");
            }
        }

        public boolean visitField(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstNames, @Nullable String @Nullable [] dstDescs) {
            return true;
        }

        public void visitFieldComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstNames, @Nullable String @Nullable [] dstDescs, String comment) throws IOException {
            if (!this.jarIndex.fieldExists(srcClsName, srcName, srcDesc)) {
                this.errorReporter.reportError(CODE_ELEMENT_MISSING, this.currentPath, "Field %s.%s:%s does not exist".formatted(srcClsName, srcName, srcDesc));
            }
        }

        public boolean visitMethod(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstNames, @Nullable String @Nullable [] dstDescs) {
            return true;
        }

        public void visitMethodComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstNames, @Nullable String @Nullable [] dstDescs, String comment) throws IOException {
            if (!this.jarIndex.methodExists(srcClsName, srcName, srcDesc)) {
                this.errorReporter.reportError(CODE_ELEMENT_MISSING, this.currentPath, "Method %s.%s%s does not exist".formatted(srcClsName, srcName, srcDesc));
            }
        }

        public boolean visitMethodArg(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstMethodNames, @Nullable String @Nullable [] dstMethodDescs, String[] dstNames) {
            return true;
        }

        public void visitMethodArgComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstMethodNames, @Nullable String @Nullable [] dstMethodDescs, @Nullable String @Nullable [] dstNames, String comment) throws IOException {
            if (!this.jarIndex.methodExists(srcClsName, srcMethodName, srcMethodDesc)) {
                this.errorReporter.reportError(CODE_ELEMENT_MISSING, this.currentPath, "Method %s.%s%s does not exist".formatted(srcClsName, srcMethodName, srcMethodDesc));
            }
        }

        public boolean visitMethodVar(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstMethodNames, @Nullable String @Nullable [] dstMethodDescs, String[] dstNames) {
            return true;
        }

        public void visitMethodVarComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, @Nullable String @Nullable [] dstClsNames, @Nullable String @Nullable [] dstMethodNames, @Nullable String @Nullable [] dstMethodDescs, @Nullable String @Nullable [] dstNames, String comment) throws IOException {
            if (!this.jarIndex.methodExists(srcClsName, srcMethodName, srcMethodDesc)) {
                this.errorReporter.reportError(CODE_ELEMENT_MISSING, this.currentPath, "Method %s.%s%s does not exist".formatted(srcClsName, srcMethodName, srcMethodDesc));
            }
        }
    }

    private static final class MappingChecker
    extends ForwardingMappingVisitor {
        private final String expectedNamespace;
        private final ErrorReporter errorReporter;
        private final Path currentPath;

        private MappingChecker(MappingVisitor next, String expectedNamespace, ErrorReporter errorReporter, Path currentPath) {
            super(next);
            this.expectedNamespace = expectedNamespace;
            this.errorReporter = errorReporter;
            this.currentPath = currentPath;
        }

        public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
            if (!this.expectedNamespace.equals(srcNamespace) && !"source".equals(srcNamespace)) {
                this.errorReporter.reportError(INCORRECT_MAPPING_SRC_NAME, this.currentPath, "Expected %s or %s for the source namespace, but found %s.".formatted(this.expectedNamespace, "source", srcNamespace));
            }
            super.visitNamespaces(srcNamespace, dstNamespaces);
        }

        public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
            this.errorReporter.reportError(MAPPINGS_CONTAIN_DST_NAMES, this.currentPath, "These mappings cannot contain any destination names. They can only contain javadoc.");
        }
    }

    private static final class GameJarIndex
    implements Closeable {
        private final List<FileSystemUtil.Delegate> fileSystems;
        private final Map<String, ClassNode> classNodes = new HashMap<String, ClassNode>();

        private GameJarIndex(Collection<File> files) throws IOException {
            this.fileSystems = new ArrayList<FileSystemUtil.Delegate>(files.size());
            for (File file : files) {
                this.fileSystems.add(FileSystemUtil.getJarFileSystem(file.toPath()));
            }
        }

        public boolean classExists(String className) throws IOException {
            if (this.classNodes.containsKey(className)) {
                return true;
            }
            for (FileSystemUtil.Delegate fileSystem : this.fileSystems) {
                Path classFile = fileSystem.getPath(className + ".class", new String[0]);
                if (!Files.exists(classFile, new LinkOption[0])) continue;
                ClassNode node = new ClassNode();
                ClassReader cr = new ClassReader(Files.readAllBytes(classFile));
                cr.accept((ClassVisitor)node, 7);
                this.classNodes.put(className, node);
                return true;
            }
            return false;
        }

        public boolean fieldExists(String owner, String name, @Nullable String desc) throws IOException {
            if (desc == null || !this.classExists(owner)) {
                return false;
            }
            for (FieldNode field : this.classNodes.get((Object)owner).fields) {
                if (!name.equals(field.name) || !desc.equals(field.desc)) continue;
                return true;
            }
            return false;
        }

        public boolean methodExists(String owner, String name, @Nullable String desc) throws IOException {
            if (desc == null || !this.classExists(owner)) {
                return false;
            }
            for (MethodNode method : this.classNodes.get((Object)owner).methods) {
                if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            @Nullable IOException suppressed = null;
            for (FileSystemUtil.Delegate fs : this.fileSystems) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    if (suppressed != null) {
                        suppressed.addSuppressed(e);
                        continue;
                    }
                    suppressed = e;
                }
            }
            if (suppressed != null) {
                throw suppressed;
            }
        }
    }
}

