/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.web;

import io.javalin.http.Context;
import java.util.Collections;
import java.util.List;
import net.fabricmc.meta.FabricMeta;
import net.fabricmc.meta.data.VersionDatabase;
import net.fabricmc.meta.web.models.BaseVersion;
import net.fabricmc.meta.web.models.MavenBuildGameVersion;
import net.fabricmc.meta.web.models.MavenBuildVersion;

interface ContextUtil {
    public static String getGameRaw(Context context) {
        return context.pathParam("game_version");
    }

    public static VersionDatabase.GameVersionData getGame(Context context) {
        String version = ContextUtil.getGameRaw(context);
        return version != null ? FabricMeta.database.getGameData(version) : null;
    }

    public static BaseVersion getGameModel(Context context) {
        VersionDatabase.GameVersionData game = ContextUtil.getGame(context);
        return game != null ? game.exposedModel() : null;
    }

    public static List<MavenBuildGameVersion> getYarn(Context context) {
        VersionDatabase.GameVersionData game = ContextUtil.getGame(context);
        return game != null ? game.yarn() : Collections.emptyList();
    }

    public static MavenBuildGameVersion getFirstYarn(Context context) {
        List<MavenBuildGameVersion> ret = ContextUtil.getYarn(context);
        return !ret.isEmpty() ? ret.getFirst() : null;
    }

    public static String getLoaderRaw(Context context) {
        return context.pathParam("loader_version");
    }

    public static MavenBuildVersion getLoader(Context context) {
        String version = ContextUtil.getLoaderRaw(context);
        return version != null ? FabricMeta.database.getLoader(version) : null;
    }

    public static <T> List<T> toList(T obj) {
        return obj != null ? Collections.singletonList(obj) : Collections.emptyList();
    }
}

