/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.meta.data.VersionDatabase;
import net.fabricmc.meta.utils.McObfuscationChecker;
import net.fabricmc.meta.utils.Reference;
import net.fabricmc.meta.web.WebServer;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricMeta {
    public static Path CACHE_DIR = Paths.get("cache", new String[0]);
    public static Path DATA_DIR = Paths.get("data", new String[0]);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final McObfuscationChecker MC_OBFUSCATION_CHECKER = new McObfuscationChecker();
    public static volatile VersionDatabase database;
    private static final Logger LOGGER;
    private static final Map<String, String> config;
    private static boolean configInitialized;
    private static URL heartbeatUrl;

    public static void main(String[] args2) {
        Path configFile = Paths.get("config.json", new String[0]);
        if (Files.exists(configFile, new LinkOption[0])) {
            try (JsonReader reader = new JsonReader(Files.newBufferedReader(configFile));){
                reader.beginObject();
                while (reader.hasNext()) {
                    config.put(reader.nextName(), reader.nextString());
                }
                reader.endObject();
                String heartbeatUrlString = config.get("heartbeatUrl");
                if (heartbeatUrlString != null) {
                    heartbeatUrl = URI.create(heartbeatUrlString).toURL();
                }
            }
            catch (IOException | IllegalStateException e) {
                throw new RuntimeException("malformed config in " + String.valueOf(configFile), e);
            }
        }
        configInitialized = true;
        LOGGER.info("Starting with local maven {}", (Object)Reference.LOCAL_FABRIC_MAVEN_URL);
        FabricMeta.update(true);
        ScheduledExecutorService executorService2 = Executors.newScheduledThreadPool(1);
        executorService2.scheduleWithFixedDelay(() -> FabricMeta.update(false), 1L, 1L, TimeUnit.MINUTES);
        WebServer.start();
    }

    private static void update(boolean initial) {
        try {
            database = VersionDatabase.generate(initial);
            MC_OBFUSCATION_CHECKER.save();
            FabricMeta.updateHeartbeat();
        }
        catch (Throwable t) {
            if (database == null) {
                throw new RuntimeException(t);
            }
            LOGGER.warn("update failed", t);
        }
    }

    @VisibleForTesting
    public static void setupForTesting() {
        if (configInitialized) {
            return;
        }
        configInitialized = true;
        FabricMeta.update(false);
    }

    private static void updateHeartbeat() {
        if (heartbeatUrl == null) {
            return;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)heartbeatUrl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(5000);
            int status = conn.getResponseCode();
            if (status != 200) {
                LOGGER.warn("heartbeat request failed with status {}", (Object)status);
            }
        }
        catch (IOException e) {
            LOGGER.warn("heartbeat request failed: {}", (Object)e.toString());
        }
    }

    public static Map<String, String> getConfig() {
        if (!configInitialized) {
            throw new IllegalStateException("accessing config before initialization");
        }
        return config;
    }

    static {
        LOGGER = LoggerFactory.getLogger(VersionDatabase.class);
        config = new HashMap<String, String>();
    }
}

