/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.utils;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.meta.FabricMeta;
import org.apache.commons.io.IOUtils;

public class McObfuscationChecker {
    private static final Path FILE = FabricMeta.CACHE_DIR.resolve("obfuscated_mc_versions.json");
    private static final OffsetDateTime FIRST_MODERN_UNOBF_RELEASE = OffsetDateTime.of(2025, 10, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private boolean dirty;

    public McObfuscationChecker() {
        if (Files.exists(FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(FILE);){
                Collection<Entry> entries = FabricMeta.GSON.fromJson((Reader)reader, new TypeToken<Collection<Entry>>(this){});
                for (Entry entry : entries) {
                    this.entries.put(entry.version(), entry);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void save() throws IOException {
        if (!this.dirty) {
            return;
        }
        Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(FILE, new OpenOption[0]);){
            FabricMeta.GSON.toJson(this.entries.values(), (Appendable)writer);
        }
        this.dirty = false;
    }

    public boolean isObfuscated(String version, String url2, byte[] hash, OffsetDateTime releaseTime) throws IOException {
        if (releaseTime.isBefore(FIRST_MODERN_UNOBF_RELEASE)) {
            return true;
        }
        Entry entry = this.entries.get(version);
        if (entry != null && (hash == null || entry.hash() == null || Arrays.equals(hash, entry.hash()))) {
            return entry.obfuscated();
        }
        boolean obfuscated = McObfuscationChecker.hasMojmapFiles(version, url2);
        this.entries.put(version, new Entry(version, hash, obfuscated));
        this.dirty = true;
        return obfuscated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasMojmapFiles(String id, String url2) throws IOException {
        String json = IOUtils.toString(URI.create(url2), StandardCharsets.UTF_8);
        try {
            JsonReader reader;
            block21: {
                reader = new JsonReader(new StringReader(json));
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (!key.equals("downloads")) {
                        reader.skipValue();
                        continue;
                    }
                    break block21;
                }
                reader.endObject();
                throw new IOException("missing downloads section in " + id + " version json");
                finally {
                    reader.close();
                }
            }
            reader.beginObject();
            while (true) {
                if (!reader.hasNext()) {
                    reader.endObject();
                    boolean bl = false;
                    return bl;
                }
                switch (reader.nextName()) {
                    case "client_mappings": 
                    case "server_mappings": {
                        boolean bl = true;
                        return bl;
                    }
                }
                reader.skipValue();
            }
        }
        catch (DateTimeParseException e) {
            throw new IOException("error parsing releaseTime: " + String.valueOf(e));
        }
        catch (IllegalStateException e) {
            throw new IOException("error parsing json: " + String.valueOf(e));
        }
    }

    private record Entry(String version, byte[] hash, boolean obfuscated) {
    }
}

