/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.meta.web;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.meta.FabricMeta;
import net.fabricmc.meta.web.ContextUtil;
import net.fabricmc.meta.web.WebServer;
import net.fabricmc.meta.web.models.LoaderInfoV1;
import net.fabricmc.meta.web.models.MavenBuildGameVersion;
import net.fabricmc.meta.web.models.MavenBuildVersion;

public class EndpointsV1 {
    public static void setup() {
        WebServer.jsonGet("/v1/versions", () -> FabricMeta.database.createLegacyDbDump());
        WebServer.jsonGet("/v1/versions/game", () -> FabricMeta.database.getGameModels());
        WebServer.jsonGet("/v1/versions/game/{game_version}", context -> ContextUtil.toList(ContextUtil.getGameModel(context)));
        WebServer.jsonGet("/v1/versions/mappings", () -> FabricMeta.database.getYarnModels());
        WebServer.jsonGet("/v1/versions/mappings/{game_version}", ContextUtil::getYarn);
        WebServer.jsonGet("/v1/versions/loader", () -> FabricMeta.database.getLoader());
        WebServer.jsonGet("/v1/versions/loader/{game_version}", EndpointsV1::getLoaderInfoAll);
        WebServer.jsonGet("/v1/versions/loader/{game_version}/{loader_version}", EndpointsV1::getLoaderInfo);
    }

    private static Object getLoaderInfo(Context context) {
        MavenBuildVersion loader = ContextUtil.getLoader(context);
        MavenBuildGameVersion mappings = ContextUtil.getFirstYarn(context);
        if (loader == null) {
            context.status(400);
            return "no loader version found for " + ContextUtil.getLoaderRaw(context);
        }
        if (mappings == null) {
            context.status(400);
            return "no mappings version found for " + ContextUtil.getGameRaw(context);
        }
        return new LoaderInfoV1(loader, mappings).populateMeta();
    }

    private static Object getLoaderInfoAll(Context context) {
        MavenBuildGameVersion mappings = ContextUtil.getFirstYarn(context);
        if (mappings == null) {
            return Collections.emptyList();
        }
        ArrayList<LoaderInfoV1> infoList = new ArrayList<LoaderInfoV1>();
        for (MavenBuildVersion loader : FabricMeta.database.getLoader()) {
            infoList.add(new LoaderInfoV1(loader, mappings));
        }
        return infoList;
    }
}

