/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.mixin.annotation.AccessorData;
import org.cadixdev.mercury.mixin.annotation.AccessorName;
import org.cadixdev.mercury.mixin.annotation.AccessorType;
import org.cadixdev.mercury.mixin.annotation.AtData;
import org.cadixdev.mercury.mixin.annotation.InjectData;
import org.cadixdev.mercury.mixin.annotation.InjectTarget;
import org.cadixdev.mercury.mixin.annotation.MixinClass;
import org.cadixdev.mercury.mixin.annotation.ShadowData;
import org.cadixdev.mercury.mixin.annotation.SliceData;
import org.cadixdev.mercury.mixin.util.MixinConstants;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.AST;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTNode;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTVisitor;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Annotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Expression;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IExtendedModifier;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMethodBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IVariableBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.InfixExpression;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.MemberValuePair;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.SimpleName;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.StringLiteral;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.cadixdev.mercury.util.BombeBindings;

public class MixinRemapperVisitor
extends ASTVisitor {
    final RewriteContext context;
    final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    MixinRemapperVisitor(RewriteContext context, MappingSet mappings) {
        this.context = context;
        this.mappings = mappings;
        this.inheritanceProvider = MercuryInheritanceProvider.get((Mercury)context.getMercury());
    }

    private void remapPrivateMixinTarget(AST ast, TypeDeclaration typeDeclaration, ITypeBinding binding) {
        for (Object rawModifier : typeDeclaration.modifiers()) {
            IExtendedModifier modifier = (IExtendedModifier)rawModifier;
            if (!modifier.isAnnotation()) {
                return;
            }
            Annotation rawAnnot = (Annotation)modifier;
            if (!rawAnnot.isNormalAnnotation()) continue;
            NormalAnnotation annot = (NormalAnnotation)rawAnnot;
            for (Object raw : annot.values()) {
                StringLiteral target;
                MemberValuePair pair = (MemberValuePair)raw;
                if (!Objects.equals("targets", pair.getName().getIdentifier())) continue;
                Expression targets = pair.getValue();
                if (targets instanceof StringLiteral) {
                    target = (StringLiteral)targets;
                    this.remapPrivateMixinTargetLiteral(ast, target);
                    continue;
                }
                if (!(targets instanceof ArrayInitializer)) continue;
                target = (ArrayInitializer)targets;
                for (Object expression : target.expressions()) {
                    if (!(expression instanceof StringLiteral)) continue;
                    this.remapPrivateMixinTargetLiteral(ast, (StringLiteral)expression);
                }
            }
        }
    }

    private void remapPrivateMixinTargetLiteral(AST ast, StringLiteral literal) {
        String className = literal.getLiteralValue();
        if (className.isEmpty()) {
            return;
        }
        boolean binaryFormat = className.contains("/");
        ClassMapping classMapping = this.mappings.getTopLevelClassMapping(className).orElse(null);
        if (classMapping == null) {
            classMapping = this.mappings.getClassMapping(className).orElse(null);
        }
        if (classMapping != null) {
            String remappedClassName = classMapping.getFullDeobfuscatedName();
            MixinRemapperVisitor.replaceExpression(ast, this.context, (Expression)literal, binaryFormat ? remappedClassName : remappedClassName.replace('/', '.'));
        }
    }

    void remapField(SimpleName node, IVariableBinding binding) {
        if (!binding.isField()) {
            return;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        MixinClass mixin = MixinClass.fetch(declaringClass, this.mappings);
        if (mixin == null) {
            return;
        }
        ClassMapping target = this.mappings.getOrCreateClassMapping(mixin.getTargetNames()[0]);
        for (IAnnotationBinding annotation : binding.getAnnotations()) {
            String annotationType = annotation.getAnnotationType().getBinaryName();
            if (!Objects.equals("org.spongepowered.asm.mixin.Shadow", annotationType)) continue;
            ShadowData shadow = ShadowData.from(annotation);
            boolean usedPrefix = binding.getName().startsWith(shadow.getPrefix());
            FieldSignature targetSignature = MixinRemapperVisitor.convertSignature(shadow.stripPrefix(binding.getName()), binding.getType());
            FieldSignature mixinSignature = BombeBindings.convertSignature((IVariableBinding)binding);
            mixin.copyFieldMapping(target, mixinSignature, targetSignature, deobfName -> usedPrefix ? shadow.prefix((String)deobfName) : deobfName);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean visit(MethodDeclaration node) {
        AST ast = this.context.getCompilationUnit().getAST();
        IMethodBinding binding = node.resolveBinding();
        ITypeBinding declaringClass = binding.getDeclaringClass();
        MixinClass mixin = MixinClass.fetch(declaringClass, this.mappings);
        if (mixin == null) {
            return true;
        }
        if (node.getName().getIdentifier().contains("$")) {
            String[] split = node.getName().getIdentifier().split("\\$");
            ITypeBinding[] prefix = split[0];
            String name = split[1];
            if (mixin.getImplementsData().containsKey(prefix)) {
                ITypeBinding iface = mixin.getImplementsData().get(prefix);
                ClassMapping target = this.mappings.getOrCreateClassMapping(iface.getBinaryName());
                MethodSignature targetSignature = MixinRemapperVisitor.convertSignature(name, binding);
                MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                mixin.copyMethodMapping(target, mixinSignature, targetSignature, arg_0 -> MixinRemapperVisitor.lambda$visit$1((String)prefix, arg_0));
                return true;
            }
        }
        ClassMapping target = this.mappings.getOrCreateClassMapping(mixin.getTargetNames()[0]);
        for (ITypeBinding mixinTarget : mixin.getTargets(this.context.getMercury())) {
            target.complete(this.inheritanceProvider, (Object)mixinTarget);
        }
        int i = 0;
        while (true) {
            block34: {
                NormalAnnotation originalAnnotation;
                InjectTarget[] inject;
                String annotationType;
                IAnnotationBinding annotation;
                block33: {
                    if (i >= binding.getAnnotations().length) {
                        return true;
                    }
                    annotation = binding.getAnnotations()[i];
                    annotationType = annotation.getAnnotationType().getBinaryName();
                    if (Objects.equals("org.spongepowered.asm.mixin.Shadow", annotationType)) {
                        ShadowData shadow = ShadowData.from(annotation);
                        boolean usedPrefix = binding.getName().startsWith(shadow.getPrefix());
                        MethodSignature targetSignature = MixinRemapperVisitor.convertSignature(shadow.stripPrefix(binding.getName()), binding);
                        MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                        mixin.copyMethodMapping(target, mixinSignature, targetSignature, deobfName -> usedPrefix ? shadow.prefix((String)deobfName) : deobfName);
                    }
                    if (Objects.equals("org.spongepowered.asm.mixin.Overwrite", annotationType)) {
                        MethodSignature signature = BombeBindings.convertSignature((IMethodBinding)binding);
                        mixin.copyMethodMapping(target, signature, s -> s);
                    }
                    if (!Objects.equals("org.spongepowered.asm.mixin.gen.Accessor", annotationType) && !Objects.equals("org.spongepowered.asm.mixin.gen.Invoker", annotationType)) break block33;
                    AccessorName name = AccessorName.of(binding.getName());
                    AccessorData accessor = AccessorData.from(annotation);
                    MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                    AccessorType type = AccessorType.get(Objects.equals("org.spongepowered.asm.mixin.gen.Invoker", annotationType), binding, mixinSignature, accessor);
                    boolean inflect = accessor.getTarget().isEmpty();
                    String targetName = inflect ? name.getName() : accessor.getTarget();
                    switch (type) {
                        case FIELD_GETTER: 
                        case FIELD_SETTER: {
                            Annotation rawAnnotation;
                            MethodSignature targetSignature = new FieldSignature(targetName, type == AccessorType.FIELD_GETTER ? (FieldType)mixinSignature.getDescriptor().getReturnType() : (FieldType)mixinSignature.getDescriptor().getParamTypes().get(0));
                            FieldMapping targetField = target.computeFieldMapping((FieldSignature)targetSignature).orElse(null);
                            if (targetField != null) {
                                if (inflect) {
                                    mixin.copyMethodMapping(target, mixinSignature, (FieldSignature)targetSignature, name::prefix);
                                    break;
                                }
                                rawAnnotation = (Annotation)node.modifiers().get(i);
                                MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetField.getDeobfuscatedName());
                                break;
                            }
                            break block34;
                        }
                        case METHOD_PROXY: {
                            Annotation rawAnnotation;
                            MethodSignature targetSignature = new MethodSignature(targetName, mixinSignature.getDescriptor());
                            MethodMapping targetMethod = target.getMethodMapping(targetSignature).orElse(null);
                            if (targetMethod != null) {
                                if (inflect) {
                                    mixin.copyMethodMapping(target, mixinSignature, targetSignature, name::prefix);
                                    break;
                                }
                                rawAnnotation = (Annotation)node.modifiers().get(i);
                                MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetMethod.getDeobfuscatedName());
                                break;
                            }
                            break block34;
                        }
                        case OBJECT_FACTORY: {
                            if (Objects.equals("<init>", accessor.getTarget())) break;
                            ClassMapping targetClass = this.mappings.computeClassMapping(accessor.getTarget()).orElse(null);
                            if (targetClass == null) break block34;
                            Annotation rawAnnotation = (Annotation)node.modifiers().get(i);
                            MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetClass.getFullDeobfuscatedName());
                        }
                    }
                }
                if (Objects.equals("org.spongepowered.asm.mixin.injection.Inject", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.Redirect", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyConstant", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyVariable", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyArg", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.WrapWithCondition", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.v2.WrapWithCondition", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyExpressionValue", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyReceiver", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyReturnValue", annotationType)) {
                    inject = InjectData.from(annotation);
                    String[] injectTargets = new String[inject.getInjectTargets().length];
                    for (int j = 0; j < inject.getInjectTargets().length; ++j) {
                        InjectTarget injectTarget = inject.getInjectTargets()[j];
                        injectTargets[j] = this.remapInjectTarget(target, injectTarget, binding);
                    }
                    originalAnnotation = (NormalAnnotation)node.modifiers().get(i);
                    int atIndex = 0;
                    int sliceIndex = 0;
                    for (Object raw : originalAnnotation.values()) {
                        NormalAnnotation atAnnotation;
                        NormalAnnotation atAnnotation2;
                        ArrayInitializer value;
                        MemberValuePair pair = (MemberValuePair)raw;
                        if (Objects.equals("method", pair.getName().getIdentifier())) {
                            this.remapMethod(ast, pair, injectTargets);
                        }
                        if (Objects.equals("at", pair.getName().getIdentifier())) {
                            if (pair.getValue() instanceof ArrayInitializer) {
                                value = (ArrayInitializer)pair.getValue();
                                for (Object expression : value.expressions()) {
                                    if (expression instanceof NormalAnnotation) {
                                        atAnnotation2 = (NormalAnnotation)expression;
                                        AtData atDatum = inject.getAtData()[atIndex];
                                        this.remapAtAnnotation(ast, declaringClass, atAnnotation2, atDatum);
                                    }
                                    ++atIndex;
                                }
                            } else if (pair.getValue() instanceof NormalAnnotation) {
                                atAnnotation = (NormalAnnotation)pair.getValue();
                                AtData atDatum = inject.getAtData()[atIndex];
                                this.remapAtAnnotation(ast, declaringClass, atAnnotation, atDatum);
                            }
                        }
                        if (!Objects.equals("slice", pair.getName().getIdentifier())) continue;
                        if (pair.getValue() instanceof ArrayInitializer) {
                            value = (ArrayInitializer)pair.getValue();
                            for (Object expression : value.expressions()) {
                                if (expression instanceof NormalAnnotation) {
                                    atAnnotation2 = (NormalAnnotation)expression;
                                    SliceData sliceDatum = inject.getSliceData()[sliceIndex];
                                    this.remapSliceAnnotation(ast, declaringClass, atAnnotation2, sliceDatum);
                                }
                                ++sliceIndex;
                            }
                            continue;
                        }
                        if (!(pair.getValue() instanceof NormalAnnotation)) continue;
                        atAnnotation = (NormalAnnotation)pair.getValue();
                        SliceData sliceDatum = inject.getSliceData()[sliceIndex];
                        this.remapSliceAnnotation(ast, declaringClass, atAnnotation, sliceDatum);
                    }
                }
                if (Objects.equals("com.bawnorton.mixinsquared.TargetHandler", annotationType)) {
                    inject = MixinRemapperVisitor.getInjectTargets(annotation, "name");
                    String[] injectTargets = new String[inject.length];
                    for (int j = 0; j < inject.length; ++j) {
                        InjectTarget injectTarget = inject[j];
                        injectTargets[j] = this.remapInjectTarget(target, injectTarget, binding);
                    }
                    originalAnnotation = (NormalAnnotation)node.modifiers().get(i);
                    for (Object raw : originalAnnotation.values()) {
                        MemberValuePair pair = (MemberValuePair)raw;
                        if (!Objects.equals("name", pair.getName().getIdentifier())) continue;
                        this.remapMethod(ast, pair, injectTargets);
                    }
                }
            }
            ++i;
        }
    }

    private static InjectTarget[] getInjectTargets(IAnnotationBinding binding, String method) {
        InjectTarget[] injectTargets = new InjectTarget[]{};
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (!Objects.equals(method, pair.getName())) continue;
            Object[] raw = (Object[])pair.getValue();
            injectTargets = new InjectTarget[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                injectTargets[i] = InjectTarget.of((String)raw[i]);
            }
        }
        return injectTargets;
    }

    private void remapMethod(AST ast, MemberValuePair pair, String[] injectTargets) {
        if (pair.getValue() instanceof StringLiteral || pair.getValue() instanceof InfixExpression) {
            MixinRemapperVisitor.replaceExpression(ast, this.context, pair.getValue(), injectTargets[0]);
        } else if (pair.getValue() instanceof ArrayInitializer) {
            ArrayInitializer array = (ArrayInitializer)pair.getValue();
            for (int j = 0; j < array.expressions().size(); ++j) {
                StringLiteral original = (StringLiteral)array.expressions().get(j);
                MixinRemapperVisitor.replaceExpression(ast, this.context, (Expression)original, injectTargets[j]);
            }
        }
    }

    private String remapInjectTarget(ClassMapping<?, ?> target, InjectTarget injectTarget, IMethodBinding binding) {
        String targetName = injectTarget.getTargetName();
        if (injectTarget.getFieldType().isPresent()) {
            Type fieldType = injectTarget.getFieldType().get();
            for (FieldMapping mapping : target.getFieldMappings()) {
                if (!Objects.equals(targetName, mapping.getObfuscatedName()) || mapping.getType().isPresent() && !Objects.equals(mapping.getType().get(), fieldType)) continue;
                FieldSignature deobfuscatedSignature = mapping.getDeobfuscatedSignature();
                String deobfuscatedFieldType = deobfuscatedSignature.getType().map(Object::toString).orElse(null);
                if (deobfuscatedFieldType == null) {
                    deobfuscatedFieldType = this.mappings.deobfuscate(fieldType).toString();
                }
                return deobfuscatedFieldType != null ? deobfuscatedSignature.getName() + ":" + deobfuscatedFieldType : deobfuscatedSignature.getName();
            }
        } else {
            MethodDescriptor methodDescriptor = injectTarget.getMethodDescriptor().orElse(null);
            boolean needsDescriptor = this.shouldCalculateDescriptor(target, targetName);
            List targetMethodParams = null;
            if (methodDescriptor == null && binding != null && needsDescriptor) {
                List<ITypeBinding> bindingParams = List.of(binding.getParameterTypes());
                int ciIndex = bindingParams.stream().filter(t -> MixinConstants.CALLBACK_TYPES.contains(t.getBinaryName())).findFirst().map(bindingParams::indexOf).orElse(-1);
                if (ciIndex != -1) {
                    ITypeBinding returnType = (ITypeBinding)bindingParams.get(ciIndex);
                    String methodParams = bindingParams.subList(0, ciIndex).stream().map(MixinRemapperVisitor::getTypeDescriptor).collect(Collectors.joining(""));
                    boolean isVoid = returnType.getBinaryName().equals("org.spongepowered.asm.mixin.injection.callback.CallbackInfo");
                    if (isVoid || returnType.getTypeParameters().length > 0) {
                        String returnTypeDesc = isVoid ? "V" : MixinRemapperVisitor.getTypeDescriptor(returnType.getTypeParameters()[0]);
                        methodDescriptor = MethodDescriptor.of((String)("(" + methodParams + ")" + returnTypeDesc));
                    } else {
                        targetMethodParams = bindingParams.subList(0, bindingParams.size() - 1);
                    }
                }
            }
            for (MethodMapping mapping : target.getMethodMappings()) {
                if (!Objects.equals(targetName, mapping.getObfuscatedName()) || !this.matchDescriptor(methodDescriptor, needsDescriptor, mapping, targetMethodParams)) continue;
                MethodSignature deobfuscatedSignature = mapping.getDeobfuscatedSignature();
                return this.shouldIncludeDescriptor(target, mapping, injectTarget.getMethodDescriptor()) ? deobfuscatedSignature.getName() + deobfuscatedSignature.getDescriptor().toString() : deobfuscatedSignature.getName();
            }
        }
        MappingSet mappings = target.getMappings();
        String targetOwner = injectTarget.getOwnerName();
        MethodDescriptor descriptor = injectTarget.getMethodDescriptor().orElse(null);
        Type type = injectTarget.getFieldType().orElse(null);
        StringBuilder remappedFull = new StringBuilder();
        if (targetOwner != null) {
            remappedFull.append("L").append(targetOwner).append(";");
        }
        remappedFull.append(targetName);
        if (descriptor != null) {
            remappedFull.append(mappings.deobfuscate(descriptor));
        }
        if (type != null) {
            remappedFull.append(':');
            remappedFull.append(mappings.deobfuscate(type));
        }
        return remappedFull.toString();
    }

    private boolean matchDescriptor(MethodDescriptor methodDescriptor, boolean needsDescriptor, MethodMapping mapping, List<ITypeBinding> targetMethodParams) {
        return methodDescriptor == null && (!needsDescriptor || this.matchParameters(mapping, targetMethodParams)) || methodDescriptor != null && methodDescriptor.equals((Object)mapping.getDescriptor());
    }

    private boolean matchParameters(MethodMapping mapping, List<ITypeBinding> mixinParams) {
        List targetParams;
        if (mixinParams != null && (targetParams = MethodDescriptor.of((String)mapping.getObfuscatedDescriptor()).getParamTypes()).size() == mixinParams.size()) {
            for (int i = 0; i < targetParams.size(); ++i) {
                if (((FieldType)targetParams.get(i)).toString().equals(MixinRemapperVisitor.getTypeDescriptor(mixinParams.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldIncludeDescriptor(ClassMapping<?, ?> target, MethodMapping mapping, Optional<MethodDescriptor> descriptor) {
        if (descriptor.isPresent()) return true;
        if (target.getMethodMappings().stream().map(Mapping::getDeobfuscatedName).filter(mapping.getDeobfuscatedName()::equals).count() <= 1L) return false;
        if (target.getMethodMappings().stream().map(Mapping::getObfuscatedName).filter(mapping.getObfuscatedName()::equals).count() != 1L) return false;
        return true;
    }

    private boolean shouldCalculateDescriptor(ClassMapping<?, ?> target, String targetName) {
        List<MethodMapping> candidates = target.getMethodMappings().stream().filter(m -> Objects.equals(targetName, m.getObfuscatedName())).toList();
        return candidates.size() > 1 && candidates.stream().anyMatch(m -> !Objects.equals(((MethodMapping)candidates.get(0)).getDeobfuscatedName(), m.getDeobfuscatedName()));
    }

    private void remapSliceAnnotation(AST ast, ITypeBinding declaringClass, NormalAnnotation atAnnotation, SliceData sliceDatum) {
        for (Object raw : atAnnotation.values()) {
            MemberValuePair pairRaw = (MemberValuePair)raw;
            if (!(pairRaw.getValue() instanceof NormalAnnotation)) continue;
            if (Objects.equals("from", pairRaw.getName().getIdentifier())) {
                this.remapAtAnnotation(ast, declaringClass, (NormalAnnotation)pairRaw.getValue(), sliceDatum.getFrom());
            }
            if (!Objects.equals("to", pairRaw.getName().getIdentifier())) continue;
            this.remapAtAnnotation(ast, declaringClass, (NormalAnnotation)pairRaw.getValue(), sliceDatum.getTo());
        }
    }

    private void remapAtAnnotation(AST ast, ITypeBinding declaringClass, NormalAnnotation atAnnotation, AtData atDatum) {
        for (Object atRaw : atAnnotation.values()) {
            MemberValuePair atRawPair = (MemberValuePair)atRaw;
            if (!Objects.equals("target", atRawPair.getName().getIdentifier())) continue;
            if (atDatum.getClassName().isPresent()) {
                String className = atDatum.getClassName().get();
                Expression originalTarget = atRawPair.getValue();
                ClassMapping atTargetMappings = this.mappings.computeClassMapping(className).orElse(null);
                if (atTargetMappings == null) continue;
                String deobfTargetClass = atTargetMappings.getFullDeobfuscatedName();
                if (atDatum.getTarget().isPresent()) {
                    InjectTarget atTarget = atDatum.getTarget().get();
                    String newTarget = this.remapInjectTarget(atTargetMappings, atTarget, null);
                    String deobfTarget = "L" + deobfTargetClass + ";" + newTarget;
                    MixinRemapperVisitor.replaceExpression(ast, this.context, originalTarget, deobfTarget);
                    continue;
                }
                MixinRemapperVisitor.replaceExpression(ast, this.context, originalTarget, deobfTargetClass);
                continue;
            }
            if (!atDatum.getTarget().isPresent()) continue;
            atDatum.getTarget().get().getMethodDescriptor().ifPresent(desc -> MixinRemapperVisitor.replaceExpression(ast, this.context, atRawPair.getValue(), this.mappings.deobfuscate(desc).toString()));
        }
    }

    private void visit(SimpleName node, IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                this.remapField(node, ((IVariableBinding)binding).getVariableDeclaration());
            }
        }
    }

    public final boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            this.visit(node, binding);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.remapPrivateMixinTarget(node.getAST(), node, node.resolveBinding());
        return true;
    }

    private static void replaceExpression(AST ast, RewriteContext context, Expression original, String replacement) {
        StringLiteral replacementLiteral = ast.newStringLiteral();
        replacementLiteral.setLiteralValue(replacement);
        context.createASTRewrite().replace((ASTNode)original, (ASTNode)replacementLiteral, null);
    }

    private static void replaceValueInAnnotation(AST ast, RewriteContext context, Annotation rawAnnotation, String replacement) {
        if (rawAnnotation.isNormalAnnotation()) {
            NormalAnnotation annotationNode = (NormalAnnotation)rawAnnotation;
            for (Object raw : annotationNode.values()) {
                MemberValuePair pair = (MemberValuePair)raw;
                if (!Objects.equals("value", pair.getName().getIdentifier())) continue;
                StringLiteral original = (StringLiteral)pair.getValue();
                MixinRemapperVisitor.replaceExpression(ast, context, (Expression)original, replacement);
            }
        } else if (rawAnnotation.isSingleMemberAnnotation()) {
            SingleMemberAnnotation annotationNode = (SingleMemberAnnotation)rawAnnotation;
            StringLiteral original = (StringLiteral)annotationNode.getValue();
            MixinRemapperVisitor.replaceExpression(ast, context, (Expression)original, replacement);
        } else {
            throw new RuntimeException("Unexpected annotation: " + rawAnnotation.getClass().getName());
        }
    }

    private static FieldSignature convertSignature(String name, ITypeBinding type) {
        return new FieldSignature(name, (FieldType)BombeBindings.convertType((ITypeBinding)type));
    }

    private static MethodSignature convertSignature(String name, IMethodBinding binding) {
        ITypeBinding[] parameterBindings = binding.getParameterTypes();
        ArrayList<FieldType> parameters = new ArrayList<FieldType>(parameterBindings.length);
        for (ITypeBinding parameterBinding : parameterBindings) {
            parameters.add((FieldType)BombeBindings.convertType((ITypeBinding)parameterBinding));
        }
        return new MethodSignature(name, new MethodDescriptor(parameters, BombeBindings.convertType((ITypeBinding)binding.getReturnType())));
    }

    private static String getTypeDescriptor(ITypeBinding binding) {
        return binding.isPrimitive() ? binding.getBinaryName() : "L" + binding.getBinaryName().replace('.', '/') + ";";
    }

    private static /* synthetic */ String lambda$visit$1(String prefix, String deobfName) {
        return prefix + "$" + deobfName;
    }
}

