/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Arrays;
import java.util.Objects;
import org.cadixdev.mercury.mixin.annotation.AtData;
import org.cadixdev.mercury.mixin.annotation.InjectTarget;
import org.cadixdev.mercury.mixin.annotation.SliceData;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;

public class InjectData {
    private final InjectTarget[] injectTargets;
    private final AtData[] atData;
    private final SliceData[] sliceData;

    public static InjectData from(IAnnotationBinding binding) {
        InjectTarget[] injectTargets = new InjectTarget[]{};
        AtData[] atData = new AtData[]{};
        SliceData[] sliceData = new SliceData[]{};
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            int i;
            Object value;
            if (Objects.equals("method", pair.getName())) {
                Object[] raw = (Object[])pair.getValue();
                injectTargets = new InjectTarget[raw.length];
                for (int i2 = 0; i2 < raw.length; ++i2) {
                    injectTargets[i2] = InjectTarget.of((String)raw[i2]);
                }
                continue;
            }
            if (Objects.equals("at", pair.getName())) {
                value = pair.getValue();
                if (value instanceof Object[]) {
                    Object[] raw = (Object[])value;
                    atData = new AtData[raw.length];
                    for (i = 0; i < raw.length; ++i) {
                        atData[i] = AtData.from((IAnnotationBinding)raw[i]);
                    }
                    continue;
                }
                if (!(value instanceof IAnnotationBinding)) continue;
                atData = new AtData[]{AtData.from((IAnnotationBinding)value)};
                continue;
            }
            if (!Objects.equals("slice", pair.getName())) continue;
            value = pair.getValue();
            if (value instanceof Object[]) {
                Object[] raw = (Object[])value;
                sliceData = new SliceData[raw.length];
                for (i = 0; i < raw.length; ++i) {
                    sliceData[i] = SliceData.from((IAnnotationBinding)raw[i]);
                }
                continue;
            }
            if (!(value instanceof IAnnotationBinding)) continue;
            sliceData = new SliceData[]{SliceData.from((IAnnotationBinding)value)};
        }
        return new InjectData(injectTargets, atData, sliceData);
    }

    public InjectData(InjectTarget[] injectTargets, AtData[] atData, SliceData[] sliceData) {
        this.injectTargets = injectTargets;
        this.atData = atData;
        this.sliceData = sliceData;
    }

    public InjectTarget[] getInjectTargets() {
        return this.injectTargets;
    }

    public AtData[] getAtData() {
        return this.atData;
    }

    public SliceData[] getSliceData() {
        return this.sliceData;
    }

    public String toString() {
        return "InjectData{methodTargets=" + Arrays.toString(this.injectTargets) + ", atData=" + Arrays.toString(this.atData) + ", sliceData=" + Arrays.toString(this.sliceData) + '}';
    }
}

