/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.cleaner;

import java.util.Objects;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.mixin.annotation.MixinData;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.AST;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTNode;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTVisitor;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IVariableBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Modifier;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Name;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.cadixdev.mercury.util.BombeBindings;

public class FinalVisitor
extends ASTVisitor {
    final RewriteContext context;
    private final InheritanceProvider inheritanceProvider;

    FinalVisitor(RewriteContext context) {
        this.context = context;
        this.inheritanceProvider = MercuryInheritanceProvider.get((Mercury)context.getMercury());
    }

    public boolean visit(FieldDeclaration node) {
        for (Object obj : node.fragments()) {
            ListRewrite rewrite;
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)obj;
            IVariableBinding binding = fragment.resolveBinding();
            FieldSignature signature = BombeBindings.convertSignature((IVariableBinding)binding);
            ITypeBinding declaringClass = binding.getDeclaringClass();
            MixinData mixin = MixinData.fetch(declaringClass);
            if (mixin == null || mixin.getTargets(this.context.getMercury()).length == 0) continue;
            ITypeBinding targetClass = mixin.getTargets(this.context.getMercury())[0];
            int shadowIndex = -1;
            int mutableIndex = -1;
            int finalIndex = -1;
            for (int i = 0; i < binding.getAnnotations().length; ++i) {
                IVariableBinding[] annotation = binding.getAnnotations()[i];
                String annotationType = annotation.getAnnotationType().getBinaryName();
                if (Objects.equals("org.spongepowered.asm.mixin.Shadow", annotationType)) {
                    shadowIndex = i;
                }
                if (Objects.equals("org.spongepowered.asm.mixin.Mutable", annotationType)) {
                    mutableIndex = i;
                }
                if (!Objects.equals("org.spongepowered.asm.mixin.Final", annotationType)) continue;
                finalIndex = i;
            }
            if (shadowIndex == -1) continue;
            boolean isTargetFinal = false;
            for (IVariableBinding field : targetClass.getDeclaredFields()) {
                FieldSignature fieldSignature = BombeBindings.convertSignature((IVariableBinding)field);
                if (!signature.equals((Object)fieldSignature)) continue;
                isTargetFinal = Modifier.isFinal((int)field.getModifiers());
                break;
            }
            if (isTargetFinal) {
                if (finalIndex != -1 || mutableIndex != -1) continue;
                AST ast = this.context.getCompilationUnit().getAST();
                MarkerAnnotation finalA = ast.newMarkerAnnotation();
                finalA.setTypeName((Name)ast.newSimpleName("Final"));
                this.context.createImportRewrite().addImport("org.spongepowered.asm.mixin.Final");
                this.context.createASTRewrite().getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY).insertAt((ASTNode)finalA, shadowIndex + 1, null);
                continue;
            }
            if (mutableIndex != -1) {
                rewrite = this.context.createASTRewrite().getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
                ASTNode mutableNode = (ASTNode)rewrite.getOriginalList().get(mutableIndex);
                rewrite.remove(mutableNode, null);
            }
            if (finalIndex == -1) continue;
            rewrite = this.context.createASTRewrite().getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
            ASTNode finalNode = (ASTNode)rewrite.getOriginalList().get(finalIndex);
            rewrite.remove(finalNode, null);
        }
        return super.visit(node);
    }
}

