/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection;

import java.util.Objects;
import net.fabricmc.tinyremapper.extension.mixin.common.IMappable;
import net.fabricmc.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.tinyremapper.extension.mixin.soft.annotation.injection.AtMemberMappable;
import net.fabricmc.tinyremapper.extension.mixin.soft.data.MemberInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AnnotationNode;

class AtAnnotationVisitor
extends AnnotationNode {
    private final CommonData data;
    private final AnnotationVisitor delegate;
    private String value;

    AtAnnotationVisitor(CommonData data, AnnotationVisitor delegate) {
        super(589824, "Lorg/spongepowered/asm/mixin/injection/At;");
        this.data = Objects.requireNonNull(data);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void visit(String name, Object value) {
        if (name.equals("value")) {
            this.value = Objects.requireNonNull((String)value);
        }
        super.visit(name, value);
    }

    @Override
    public void visitEnd() {
        this.accept(new AtSecondPassAnnotationVisitor(this.data, this.delegate, this.value));
        super.visitEnd();
    }

    private static class AtSecondPassAnnotationVisitor
    extends AnnotationVisitor {
        private final CommonData data;
        private final String value;

        AtSecondPassAnnotationVisitor(CommonData data, AnnotationVisitor delegate, String value) {
            super(589824, delegate);
            this.data = Objects.requireNonNull(data);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public void visit(String name, Object value) {
            MemberInfo info;
            if (name.equals("target") && (info = MemberInfo.parse(Objects.requireNonNull((String)value).replaceAll("\\s", ""))) != null) {
                value = this.value.equals("NEW") ? new AtConstructorMappable(this.data, info).result().toString() : new AtMemberMappable(this.data, info).result().toString();
            }
            super.visit(name, value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av = super.visitArray(name);
            if (name.equals("args") && this.value.equals("NEW")) {
                String prefix = "class=";
                av = new AnnotationVisitor(589824, av){

                    @Override
                    public void visit(String name, Object value) {
                        MemberInfo info;
                        String argument = Objects.requireNonNull((String)value);
                        if (argument.startsWith("class=") && (info = MemberInfo.parse(argument.substring("class=".length()).replaceAll("\\s", ""))) != null) {
                            value = "class=" + new AtConstructorMappable(data, info).result().toString();
                        }
                        super.visit(name, value);
                    }
                };
            }
            return av;
        }
    }

    private static class AtConstructorMappable
    implements IMappable<MemberInfo> {
        private final CommonData data;
        private final MemberInfo info;

        AtConstructorMappable(CommonData data, MemberInfo info) {
            this.data = Objects.requireNonNull(data);
            this.info = Objects.requireNonNull(info);
        }

        @Override
        public MemberInfo result() {
            if (this.info.getDesc().isEmpty()) {
                return new MemberInfo(this.data.mapper.asTrRemapper().map(this.info.getOwner()), this.info.getName(), this.info.getQuantifier(), "");
            }
            if (this.info.getDesc().endsWith(")V")) {
                return new MemberInfo(this.data.mapper.asTrRemapper().map(this.info.getOwner()), this.info.getName(), this.info.getQuantifier(), this.data.mapper.asTrRemapper().mapMethodDesc(this.info.getDesc()));
            }
            return new MemberInfo(this.info.getOwner(), this.info.getName(), this.info.getQuantifier(), this.data.mapper.asTrRemapper().mapMethodDesc(this.info.getDesc()));
        }
    }
}

