/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import net.fabricmc.tinyremapper.api.TrField;
import net.fabricmc.tinyremapper.api.TrLogger;
import net.fabricmc.tinyremapper.api.TrMember;
import net.fabricmc.tinyremapper.api.TrMethod;
import net.fabricmc.tinyremapper.extension.mixin.common.StringUtility;

public final class ResolveUtility {
    public static int FLAG_UNIQUE = 1;
    public static int FLAG_FIRST = 2;
    public static int FLAG_RECURSIVE = 4;
    public static int FLAG_NON_SYN = 8;
    private final TrEnvironment environment;
    private final TrLogger logger;

    public ResolveUtility(TrEnvironment environment) {
        this.environment = Objects.requireNonNull(environment);
        this.logger = environment.getLogger();
    }

    public Optional<TrClass> resolveClass(String name) {
        TrClass _class = this.environment.getClass(name);
        return Optional.ofNullable(_class);
    }

    private <T extends TrMember> Optional<T> resolveMember0(TrClass owner, String name, String desc, int flag, Supplier<Collection<T>> get, Supplier<Collection<T>> resolve) {
        if ((flag & (FLAG_UNIQUE | FLAG_FIRST)) == 0) {
            throw new RuntimeException("Unspecified resolution strategy, please use FLAG_UNIQUE or FLAG_FIRST.");
        }
        if (owner == null) {
            return Optional.empty();
        }
        Collection<T> collection = (flag & FLAG_RECURSIVE) != 0 ? resolve.get() : get.get();
        if ((flag & FLAG_UNIQUE) != 0) {
            if (collection.size() > 1) {
                throw new RuntimeException(String.format("The member %s:%s is ambiguous in class %s for FLAG_UNIQUE. Please use FLAG_FIRST.", name, desc, owner.getName()));
            }
            return collection.stream().findFirst();
        }
        Comparator<TrMember> comparator = (flag & FLAG_NON_SYN) != 0 ? (x, y) -> Boolean.compare(x.isSynthetic(), y.isSynthetic()) != 0 ? Boolean.compare(x.isSynthetic(), y.isSynthetic()) : Integer.compare(x.getIndex(), y.getIndex()) : Comparator.comparingInt(TrMember::getIndex);
        return collection.stream().min(comparator);
    }

    public Optional<TrField> resolveField(TrClass owner, String name, String desc, int flag) {
        return this.resolveMember0(owner, name, desc, flag, () -> owner.getFields(name, desc, false, null, null), () -> owner.resolveFields(name, desc, false, null, null));
    }

    public Optional<TrField> resolveField(String owner, String name, String desc, int flag) {
        return this.resolveClass(owner).flatMap(cls -> this.resolveField((TrClass)cls, name, desc, flag));
    }

    public Optional<TrMethod> resolveMethod(TrClass owner, String name, String desc, int flag) {
        return this.resolveMember0(owner, name, desc, flag, () -> owner.getMethods(name, desc, false, null, null), () -> owner.resolveMethods(name, desc, false, null, null));
    }

    public Optional<TrMethod> resolveMethod(String owner, String name, String desc, int flag) {
        return this.resolveClass(owner).flatMap(cls -> this.resolveMethod((TrClass)cls, name, desc, flag));
    }

    public Optional<TrMember> resolveMember(TrClass owner, String name, String desc, int flag) {
        if (desc == null) {
            throw new RuntimeException("desc cannot be null for resolveMember. Please use resolveMethod or resolveField.");
        }
        TrMember.MemberType type = StringUtility.getTypeByDesc(desc);
        if (type.equals((Object)TrMember.MemberType.FIELD)) {
            return this.resolveField(owner, name, desc, flag).map(m -> m);
        }
        if (type.equals((Object)TrMember.MemberType.METHOD)) {
            return this.resolveMethod(owner, name, desc, flag).map(m -> m);
        }
        throw new RuntimeException(String.format("Unknown member type %s", type.name()));
    }

    public Optional<TrMember> resolveMember(String owner, String name, String desc, int flag) {
        return this.resolveClass(owner).flatMap(cls -> this.resolveMember((TrClass)cls, name, desc, flag));
    }
}

