/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v3;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Writer;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupFormat;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetAnnotation;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ParenExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class UnpickV3Reader
implements AutoCloseable {
    private static final int MAX_PARSE_DEPTH = 64;
    private static final EnumMap<BinaryExpression.Operator, Integer> PRECEDENCES = new EnumMap(BinaryExpression.Operator.class);
    private final LineNumberReader reader;
    private int version;
    private String line;
    private int column;
    private int lastTokenLine;
    private int lastTokenColumn;
    private TokenType lastTokenType;
    @Nullable
    private String lastDocs;
    private String nextToken;
    private ParseState nextTokenState;
    private String nextToken2;
    private ParseState nextToken2State;

    public UnpickV3Reader(Reader reader) {
        this.reader = new LineNumberReader(reader);
    }

    public void accept(UnpickV3Visitor visitor) throws IOException {
        String string = this.line = this.reader.readLine();
        int n = 0;
        this.version = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"unpick v3", "unpick v4"}, (Object)string, n)) {
            case 0 -> 3;
            case 1 -> 4;
            default -> throw this.parseError("Missing version marker", 1, 0);
        };
        this.column = this.line.length();
        this.nextToken();
        visitor.visitHeader(this.version);
        while (true) {
            String token = this.nextToken();
            if (this.lastTokenType == TokenType.EOF) break;
            this.parseUnpickItem(visitor, token);
        }
    }

    private void parseUnpickItem(UnpickV3Visitor visitor, String token) throws IOException {
        if (this.lastTokenType != TokenType.IDENTIFIER) {
            throw this.expectedTokenError("unpick item", token);
        }
        switch (token) {
            case "target_field": {
                visitor.visitTargetField(this.parseTargetField());
                break;
            }
            case "target_method": {
                visitor.visitTargetMethod(this.parseTargetMethod());
                break;
            }
            case "target_annotation": {
                visitor.visitTargetAnnotation(this.parseTargetAnnotation());
                break;
            }
            case "group": {
                visitor.visitGroupDefinition(this.parseGroupDefinition());
                break;
            }
            default: {
                throw this.expectedTokenError("unpick item", token);
            }
        }
    }

    private GroupScope parseGroupScope() throws IOException {
        String token;
        return switch (token = this.nextToken("group scope type", TokenType.IDENTIFIER)) {
            case "package" -> new GroupScope.Package(this.parseClassName("package name"));
            case "class" -> new GroupScope.Class(this.parseClassName());
            case "method" -> {
                String className = this.parseClassName();
                String methodName = this.parseMethodName();
                String methodDesc = this.nextToken(TokenType.METHOD_DESCRIPTOR);
                yield new GroupScope.Method(className, methodName, methodDesc);
            }
            default -> throw this.expectedTokenError("group scope type", token);
        };
    }

    private GroupDefinition parseGroupDefinition() throws IOException {
        String docs = this.lastDocs;
        DataType dataType = this.parseDataType();
        if (!UnpickV3Reader.isDataTypeValidInGroup(dataType)) {
            throw this.parseError("Data type not allowed in group: " + String.valueOf((Object)dataType));
        }
        String name = this.peekTokenType() == TokenType.IDENTIFIER ? this.nextToken() : null;
        ArrayList<GroupScope> scopes = new ArrayList<GroupScope>();
        boolean flags = false;
        boolean strict = false;
        ArrayList<Expression> constants = new ArrayList<Expression>();
        GroupFormat format = null;
        boolean finishedAttributes = false;
        block12: while (true) {
            String token = this.nextToken();
            if (this.lastTokenType == TokenType.EOF) break;
            if (this.lastTokenType != TokenType.NEWLINE) {
                throw this.expectedTokenError("'\\n'", token);
            }
            if (this.peekTokenType() != TokenType.INDENT) break;
            this.nextToken();
            if ("@".equals(this.peekToken())) {
                this.nextToken();
                if (finishedAttributes) {
                    throw this.parseError("Found attribute after expression");
                }
                switch (token = this.nextToken("attribute name", TokenType.IDENTIFIER)) {
                    case "scope": {
                        scopes.add(this.parseGroupScope());
                        break;
                    }
                    case "flags": {
                        if (flags) {
                            throw this.parseError("Duplicate flags attribute");
                        }
                        if (dataType != DataType.INT && dataType != DataType.LONG) {
                            throw this.parseError("The flags attribute is not applicable to this data type");
                        }
                        if (name == null) {
                            throw this.parseError("The flags attribute is not applicable to the default group");
                        }
                        flags = true;
                        break;
                    }
                    case "strict": {
                        if (strict) {
                            throw this.parseError("Duplicate strict attribute");
                        }
                        strict = true;
                        break;
                    }
                    case "format": {
                        if (format != null) {
                            throw this.parseError("Duplicate format attribute");
                        }
                        if (dataType != DataType.INT && dataType != DataType.LONG && dataType != DataType.FLOAT && dataType != DataType.DOUBLE) {
                            throw this.parseError("The format attribute is not applicable to this data type");
                        }
                        format = this.parseGroupFormat();
                        if (format == GroupFormat.DECIMAL || format == GroupFormat.HEX || dataType == DataType.INT || dataType == DataType.LONG) continue block12;
                        throw this.parseError("This format is not applicable to floating point data types");
                    }
                    default: {
                        throw this.expectedTokenError("attribute name", token);
                    }
                }
                continue;
            }
            finishedAttributes = true;
            constants.add(this.parseExpression(0));
        }
        return new GroupDefinition(scopes, flags, strict, dataType, name, constants, format, docs);
    }

    private static boolean isDataTypeValidInGroup(DataType type) {
        return type == DataType.INT || type == DataType.LONG || type == DataType.FLOAT || type == DataType.DOUBLE || type == DataType.STRING || type == DataType.CLASS;
    }

    private GroupFormat parseGroupFormat() throws IOException {
        String token;
        return switch (token = this.nextToken("group format", TokenType.IDENTIFIER)) {
            case "decimal" -> GroupFormat.DECIMAL;
            case "hex" -> GroupFormat.HEX;
            case "binary" -> GroupFormat.BINARY;
            case "octal" -> GroupFormat.OCTAL;
            case "char" -> GroupFormat.CHAR;
            default -> throw this.expectedTokenError("group format", token);
        };
    }

    private Expression parseExpression(int parseDepth) throws IOException {
        Stack<Expression> operandStack = new Stack<Expression>();
        Stack<BinaryExpression.Operator> operatorStack = new Stack<BinaryExpression.Operator>();
        operandStack.push(this.parseUnaryExpression(parseDepth, false));
        while (true) {
            BinaryExpression.Operator operator;
            switch (this.peekToken()) {
                case "|": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_OR;
                    break;
                }
                case "^": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_XOR;
                    break;
                }
                case "&": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_AND;
                    break;
                }
                case "<<": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_SHIFT_LEFT;
                    break;
                }
                case ">>": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_SHIFT_RIGHT;
                    break;
                }
                case ">>>": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED;
                    break;
                }
                case "+": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.ADD;
                    break;
                }
                case "-": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.SUBTRACT;
                    break;
                }
                case "*": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.MULTIPLY;
                    break;
                }
                case "/": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.DIVIDE;
                    break;
                }
                case "%": {
                    BinaryExpression.Operator operator2 = BinaryExpression.Operator.MODULO;
                    break;
                }
                default: {
                    BinaryExpression.Operator operator2 = operator = null;
                }
            }
            if (operator == null) break;
            this.nextToken();
            int ourPrecedence = PRECEDENCES.get((Object)operator);
            while (!operatorStack.isEmpty() && ourPrecedence <= PRECEDENCES.get(operatorStack.peek())) {
                BinaryExpression.Operator op = (BinaryExpression.Operator)((Object)operatorStack.pop());
                Expression rhs = (Expression)operandStack.pop();
                Expression lhs = (Expression)operandStack.pop();
                operandStack.push(new BinaryExpression(lhs, rhs, op));
            }
            operatorStack.push(operator);
            operandStack.push(this.parseUnaryExpression(parseDepth, false));
        }
        Expression result = (Expression)operandStack.pop();
        while (!operatorStack.isEmpty()) {
            result = new BinaryExpression((Expression)operandStack.pop(), result, (BinaryExpression.Operator)((Object)operatorStack.pop()));
        }
        return result;
    }

    private Expression parseUnaryExpression(int parseDepth, boolean negative) throws IOException {
        String token;
        if (parseDepth > 64) {
            throw this.parseError("max parse depth reached");
        }
        switch (token = this.nextToken()) {
            case "-": {
                return new UnaryExpression(this.parseUnaryExpression(parseDepth + 1, true), UnaryExpression.Operator.NEGATE);
            }
            case "~": {
                return new UnaryExpression(this.parseUnaryExpression(parseDepth + 1, false), UnaryExpression.Operator.BIT_NOT);
            }
            case "(": {
                boolean parseAsCast;
                boolean bl = parseAsCast = this.peekTokenType() == TokenType.IDENTIFIER && ")".equals(this.peekToken2());
                if (parseAsCast) {
                    DataType castType = this.parseDataType();
                    this.nextToken();
                    return new CastExpression(castType, this.parseUnaryExpression(parseDepth + 1, false));
                }
                Expression expression = this.parseExpression(parseDepth + 1);
                this.expectToken(")");
                return new ParenExpression(expression);
            }
        }
        return switch (this.lastTokenType.ordinal()) {
            case 0 -> this.parseFieldExpression(token);
            case 3 -> {
                ParsedInteger parsedInt = this.parseInt(token, negative);
                yield new LiteralExpression(new Literal.Integer(negative ? -parsedInt.value : parsedInt.value, parsedInt.radix));
            }
            case 4 -> {
                ParsedLong parsedLong = this.parseLong(token, negative);
                yield new LiteralExpression(new Literal.Long(negative ? -parsedLong.value : parsedLong.value, parsedLong.radix));
            }
            case 2 -> {
                float parsedFloat = this.parseFloat(token, negative);
                yield new LiteralExpression(new Literal.Float(negative ? -parsedFloat : parsedFloat));
            }
            case 1 -> {
                double parsedDouble = this.parseDouble(token, negative);
                yield new LiteralExpression(new Literal.Double(negative ? -parsedDouble : parsedDouble));
            }
            case 5 -> new LiteralExpression(new Literal.Character(UnpickV3Reader.unquoteChar(token)));
            case 6 -> new LiteralExpression(new Literal.String(UnpickV3Reader.unquoteString(token)));
            default -> throw this.expectedTokenError("expression", token);
        };
    }

    private FieldExpression parseFieldExpression(String token) throws IOException {
        this.expectToken(".");
        StringBuilder classAndFieldNameBuilder = new StringBuilder(token).append('.');
        while (true) {
            if ("*".equals(this.peekToken())) {
                this.nextToken();
                classAndFieldNameBuilder.append('*');
                break;
            }
            classAndFieldNameBuilder.append(this.nextToken(TokenType.IDENTIFIER));
            if (!".".equals(this.peekToken())) break;
            this.nextToken();
            classAndFieldNameBuilder.append('.');
        }
        String classAndFieldName = classAndFieldNameBuilder.toString();
        int dotIndex = classAndFieldName.lastIndexOf(46);
        String className = classAndFieldName.substring(0, dotIndex);
        String fieldName = classAndFieldName.substring(dotIndex + 1);
        if ("*".equals(fieldName)) {
            fieldName = null;
        }
        boolean isStatic = true;
        DataType fieldType = null;
        if (":".equals(this.peekToken())) {
            this.nextToken();
            if ("instance".equals(this.peekToken())) {
                this.nextToken();
                isStatic = false;
                if (":".equals(this.peekToken())) {
                    this.nextToken();
                    fieldType = this.parseDataType();
                }
            } else {
                fieldType = this.parseDataType();
            }
        }
        return new FieldExpression(className, fieldName, fieldType, isStatic);
    }

    private TargetField parseTargetField() throws IOException {
        String className = this.parseClassName();
        String fieldName = this.nextToken(TokenType.IDENTIFIER);
        String fieldDesc = this.nextToken(TokenType.TYPE_DESCRIPTOR);
        String groupName = this.nextToken(TokenType.IDENTIFIER);
        String token = this.nextToken();
        if (this.lastTokenType != TokenType.NEWLINE && this.lastTokenType != TokenType.EOF) {
            throw this.expectedTokenError("'\n'", token);
        }
        return new TargetField(className, fieldName, fieldDesc, groupName);
    }

    private TargetMethod parseTargetMethod() throws IOException {
        String returnGroup;
        HashMap<Integer, String> paramGroups;
        String methodDesc;
        String methodName;
        String className;
        block12: {
            String token;
            className = this.parseClassName();
            methodName = this.parseMethodName();
            methodDesc = this.nextToken(TokenType.METHOD_DESCRIPTOR);
            paramGroups = new HashMap<Integer, String>();
            returnGroup = null;
            block8: while (true) {
                token = this.nextToken();
                if (this.lastTokenType == TokenType.EOF) break block12;
                if (this.lastTokenType != TokenType.NEWLINE) {
                    throw this.expectedTokenError("'\\n'", token);
                }
                if (this.peekTokenType() != TokenType.INDENT) break block12;
                this.nextToken();
                switch (token = this.nextToken("target method item", TokenType.IDENTIFIER)) {
                    case "param": {
                        int paramIndex = this.parseInt((String)this.nextToken((TokenType)TokenType.INTEGER), (boolean)false).value;
                        if (paramGroups.containsKey(paramIndex)) {
                            throw this.parseError("Specified parameter " + paramIndex + " twice");
                        }
                        paramGroups.put(paramIndex, this.nextToken(TokenType.IDENTIFIER));
                        continue block8;
                    }
                    case "return": {
                        if (returnGroup != null) {
                            throw this.parseError("Specified return group twice");
                        }
                        returnGroup = this.nextToken(TokenType.IDENTIFIER);
                        continue block8;
                    }
                }
                break;
            }
            throw this.expectedTokenError("target method item", token);
        }
        return new TargetMethod(className, methodName, methodDesc, paramGroups, returnGroup);
    }

    private TargetAnnotation parseTargetAnnotation() throws IOException {
        if (this.version < 4) {
            throw this.parseError("Target annotations are not supported in unpick format version " + this.version);
        }
        String annotationName = this.parseClassName();
        String groupName = this.nextToken(TokenType.IDENTIFIER);
        String token = this.nextToken();
        if (this.lastTokenType != TokenType.NEWLINE && this.lastTokenType != TokenType.EOF) {
            throw this.expectedTokenError("'\n'", token);
        }
        return new TargetAnnotation(annotationName, groupName);
    }

    private DataType parseDataType() throws IOException {
        String token;
        return switch (token = this.nextToken("data type", TokenType.IDENTIFIER)) {
            case "byte" -> DataType.BYTE;
            case "short" -> DataType.SHORT;
            case "int" -> DataType.INT;
            case "long" -> DataType.LONG;
            case "float" -> DataType.FLOAT;
            case "double" -> DataType.DOUBLE;
            case "char" -> DataType.CHAR;
            case "String" -> DataType.STRING;
            case "Class" -> DataType.CLASS;
            default -> throw this.expectedTokenError("data type", token);
        };
    }

    private String parseClassName() throws IOException {
        return this.parseClassName("class name");
    }

    private String parseClassName(String expected) throws IOException {
        StringBuilder result = new StringBuilder(this.nextToken(expected, TokenType.IDENTIFIER));
        while (".".equals(this.peekToken())) {
            this.nextToken();
            result.append('.').append(this.nextToken(TokenType.IDENTIFIER));
        }
        return result.toString();
    }

    private String parseMethodName() throws IOException {
        String token = this.nextToken();
        if (this.lastTokenType == TokenType.IDENTIFIER) {
            return token;
        }
        if ("<".equals(token)) {
            token = this.nextToken(TokenType.IDENTIFIER);
            if (!"init".equals(token) && !"clinit".equals(token)) {
                throw this.expectedTokenError("identifier", token);
            }
            this.expectToken(">");
            return "<" + token + ">";
        }
        throw this.expectedTokenError("identifier", token);
    }

    private ParsedInteger parseInt(String string, boolean negative) throws UnpickSyntaxException {
        int radix;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            radix = 16;
            string = string.substring(2);
        } else if (string.startsWith("0b") || string.startsWith("0B")) {
            radix = 2;
            string = string.substring(2);
        } else if (string.startsWith("0") && string.length() > 1) {
            radix = 8;
            string = string.substring(1);
        } else {
            radix = 10;
        }
        try {
            return new ParsedInteger(Integer.parseInt((String)(negative ? "-" + string : string), radix), radix);
        }
        catch (NumberFormatException numberFormatException) {
            if (!negative && radix != 10) {
                try {
                    return new ParsedInteger(Integer.parseUnsignedInt(string, radix), radix);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            throw this.parseError("Integer out of bounds");
        }
    }

    private ParsedLong parseLong(String string, boolean negative) throws UnpickSyntaxException {
        int radix;
        if (string.endsWith("l") || string.endsWith("L")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            radix = 16;
            string = string.substring(2);
        } else if (string.startsWith("0b") || string.startsWith("0B")) {
            radix = 2;
            string = string.substring(2);
        } else if (string.startsWith("0") && string.length() > 1) {
            radix = 8;
            string = string.substring(1);
        } else {
            radix = 10;
        }
        try {
            return new ParsedLong(Long.parseLong((String)(negative ? "-" + string : string), radix), radix);
        }
        catch (NumberFormatException numberFormatException) {
            if (!negative && radix != 10) {
                try {
                    return new ParsedLong(Long.parseUnsignedLong(string, radix), radix);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            throw this.parseError("Long out of bounds");
        }
    }

    private float parseFloat(String string, boolean negative) throws UnpickSyntaxException {
        if (string.endsWith("f") || string.endsWith("F")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            float result = Float.parseFloat(string);
            if (!Float.isFinite(result)) {
                throw this.parseError("Float out of bounds");
            }
            return negative ? -result : result;
        }
        catch (NumberFormatException e) {
            throw this.parseError("Invalid float");
        }
    }

    private double parseDouble(String string, boolean negative) throws UnpickSyntaxException {
        try {
            double result = Double.parseDouble(string);
            if (!Double.isFinite(result)) {
                throw this.parseError("Double out of bounds");
            }
            return negative ? -result : result;
        }
        catch (NumberFormatException e) {
            throw this.parseError("Invalid double");
        }
    }

    private static char unquoteChar(String string) {
        return UnpickV3Reader.unquoteString(string).charAt(0);
    }

    private static String unquoteString(String string) {
        StringBuilder result = new StringBuilder(string.length() - 2);
        block12: for (int i = 1; i < string.length() - 1; ++i) {
            if (string.charAt(i) == '\\') {
                switch (string.charAt(++i)) {
                    case 'u': {
                        while (string.charAt(++i) == 'u') {
                        }
                        result.append((char)Integer.parseInt(string.substring(i, i + 4), 16));
                        i += 3;
                        continue block12;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block12;
                    }
                    case 't': {
                        result.append('\t');
                        continue block12;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block12;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block12;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block12;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block12;
                    }
                    case '\'': {
                        result.append('\'');
                        continue block12;
                    }
                    case '\\': {
                        result.append('\\');
                        continue block12;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c;
                        int count;
                        int maxCount;
                        int n = maxCount = string.charAt(i) <= '3' ? 3 : 2;
                        for (count = 0; count < maxCount && (c = string.charAt(i + count)) >= '0' && c <= '7'; ++count) {
                        }
                        result.append((char)Integer.parseInt(string.substring(i, i + count), 8));
                        i += count - 1;
                        continue block12;
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected escape sequence in string");
                    }
                }
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    private TokenType peekTokenType() throws IOException {
        ParseState state = new ParseState(this);
        this.nextToken = this.nextToken();
        this.nextTokenState = new ParseState(this);
        state.restore(this);
        return this.nextTokenState.lastTokenType;
    }

    private String peekToken() throws IOException {
        ParseState state = new ParseState(this);
        this.nextToken = this.nextToken();
        this.nextTokenState = new ParseState(this);
        state.restore(this);
        return this.nextToken;
    }

    private String peekToken2() throws IOException {
        ParseState state = new ParseState(this);
        String nextToken = this.nextToken();
        ParseState nextTokenState = new ParseState(this);
        this.nextToken2 = this.nextToken();
        this.nextToken2State = new ParseState(this);
        this.nextToken = nextToken;
        this.nextTokenState = nextTokenState;
        state.restore(this);
        return this.nextToken2;
    }

    private void expectToken(String expected) throws IOException {
        String token = this.nextToken();
        if (!expected.equals(token)) {
            throw this.expectedTokenError(UnpickV3Writer.quoteString(expected, '\''), token);
        }
    }

    private String nextToken() throws IOException {
        return this.nextTokenInner(null);
    }

    private String nextToken(TokenType type) throws IOException {
        return this.nextToken(type.name, type);
    }

    private String nextToken(String expected, TokenType type) throws IOException {
        String token = this.nextTokenInner(type);
        if (this.lastTokenType != type) {
            throw this.expectedTokenError(expected, token);
        }
        return token;
    }

    private String nextTokenInner(@Nullable TokenType typeHint) throws IOException {
        if (this.nextTokenState != null) {
            String tok = this.nextToken;
            this.nextToken = this.nextToken2;
            this.nextToken2 = null;
            this.nextTokenState.restore(this);
            this.nextTokenState = this.nextToken2State;
            this.nextToken2State = null;
            return tok;
        }
        if (this.lastTokenType == TokenType.EOF) {
            return null;
        }
        if (this.lastTokenType != TokenType.NEWLINE && this.lastTokenType != TokenType.INDENT) {
            this.lastDocs = null;
        }
        while (this.column < this.line.length() && Character.isWhitespace(this.line.charAt(this.column))) {
            ++this.column;
        }
        this.processCommentIfPresent();
        if (this.column == this.line.length() && this.lastTokenType != TokenType.NEWLINE) {
            this.lastTokenColumn = this.column;
            this.lastTokenLine = this.reader.getLineNumber();
            this.lastTokenType = TokenType.NEWLINE;
            return "\n";
        }
        boolean seenIndent = false;
        while (true) {
            this.processCommentIfPresent();
            if (this.column == this.line.length()) {
                seenIndent = false;
                this.line = this.reader.readLine();
                this.column = 0;
                if (this.line != null) continue;
                this.lastTokenColumn = this.column;
                this.lastTokenLine = this.reader.getLineNumber();
                this.lastTokenType = TokenType.EOF;
                return null;
            }
            if (!Character.isWhitespace(this.line.charAt(this.column))) break;
            seenIndent = this.column == 0;
            do {
                ++this.column;
            } while (this.column < this.line.length() && Character.isWhitespace(this.line.charAt(this.column)));
        }
        if (seenIndent) {
            this.lastTokenColumn = 0;
            this.lastTokenLine = this.reader.getLineNumber();
            this.lastTokenType = TokenType.INDENT;
            return this.line.substring(0, this.column);
        }
        this.lastTokenColumn = this.column;
        this.lastTokenLine = this.reader.getLineNumber();
        if (typeHint == TokenType.TYPE_DESCRIPTOR && this.skipFieldDescriptor(true)) {
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        if (typeHint == TokenType.METHOD_DESCRIPTOR && this.skipMethodDescriptor()) {
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        if (this.skipNumber()) {
            if (this.column < this.line.length() && UnpickV3Reader.isIdentifierChar(this.line.charAt(this.column))) {
                throw this.parseErrorInToken("Unexpected character in number: " + this.line.charAt(this.column));
            }
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        if (this.skipIdentifier()) {
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        if (this.skipString('\'', true)) {
            this.lastTokenType = TokenType.CHAR;
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        if (this.skipString('\"', false)) {
            this.lastTokenType = TokenType.STRING;
            return this.line.substring(this.lastTokenColumn, this.column);
        }
        char c = this.line.charAt(this.column);
        ++this.column;
        if (c == '<') {
            if (this.column < this.line.length() && this.line.charAt(this.column) == '<') {
                ++this.column;
            }
        } else if (c == '>' && this.column < this.line.length() && this.line.charAt(this.column) == '>') {
            ++this.column;
            if (this.column < this.line.length() && this.line.charAt(this.column) == '>') {
                ++this.column;
            }
        }
        this.lastTokenType = TokenType.OPERATOR;
        return this.line.substring(this.lastTokenColumn, this.column);
    }

    private void processCommentIfPresent() {
        if (this.column >= this.line.length() || this.line.charAt(this.column) != '#') {
            return;
        }
        ++this.column;
        if (this.column < this.line.length() && this.line.charAt(this.column) == ':') {
            do {
                ++this.column;
            } while (this.column < this.line.length() && Character.isWhitespace(this.line.charAt(this.column)));
            this.lastDocs = this.lastDocs == null ? "" : this.lastDocs + "\n";
            this.lastDocs = this.lastDocs + this.line.substring(this.column);
        } else {
            this.lastDocs = null;
        }
        this.column = this.line.length();
    }

    private boolean skipFieldDescriptor(boolean startOfToken) throws UnpickSyntaxException {
        while (this.column < this.line.length() && this.line.charAt(this.column) == '[') {
            startOfToken = false;
            ++this.column;
        }
        if (this.column == this.line.length() || UnpickV3Reader.isTokenEnd(this.line.charAt(this.column))) {
            throw this.parseErrorInToken("Unexpected end of descriptor");
        }
        switch (this.line.charAt(this.column)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                ++this.column;
                break;
            }
            case 'L': {
                char c;
                ++this.column;
                while (this.column < this.line.length() && (c = this.line.charAt(this.column)) != ';' && !UnpickV3Reader.isTokenEnd(c)) {
                    if (c == '.' || c == '[') {
                        throw this.parseErrorInToken("Illegal character in descriptor: " + c);
                    }
                    ++this.column;
                }
                if (this.column == this.line.length() || UnpickV3Reader.isTokenEnd(this.line.charAt(this.column))) {
                    throw this.parseErrorInToken("Unexpected end of descriptor");
                }
                ++this.column;
                break;
            }
            default: {
                if (!startOfToken) {
                    throw this.parseErrorInToken("Illegal character in descriptor: " + this.line.charAt(this.column));
                }
                return false;
            }
        }
        this.lastTokenType = TokenType.TYPE_DESCRIPTOR;
        return true;
    }

    private boolean skipMethodDescriptor() throws UnpickSyntaxException {
        if (this.line.charAt(this.column) != '(') {
            return false;
        }
        ++this.column;
        while (this.column < this.line.length() && this.line.charAt(this.column) != ')' && !UnpickV3Reader.isTokenEnd(this.line.charAt(this.column))) {
            this.skipFieldDescriptor(false);
        }
        if (this.column == this.line.length() || UnpickV3Reader.isTokenEnd(this.line.charAt(this.column))) {
            throw this.parseErrorInToken("Unexpected end of descriptor");
        }
        ++this.column;
        if (this.column == this.line.length() || UnpickV3Reader.isTokenEnd(this.line.charAt(this.column))) {
            throw this.parseErrorInToken("Unexpected end of descriptor");
        }
        if (this.line.charAt(this.column) == 'V') {
            ++this.column;
        } else {
            this.skipFieldDescriptor(false);
        }
        this.lastTokenType = TokenType.METHOD_DESCRIPTOR;
        return true;
    }

    private boolean skipNumber() throws UnpickSyntaxException {
        char c;
        if (this.line.charAt(this.column) < '0' || this.line.charAt(this.column) > '9') {
            return false;
        }
        if (this.line.startsWith("0x", this.column) || this.line.startsWith("0X", this.column)) {
            char c2;
            this.column += 2;
            boolean seenDigit = false;
            while (this.column < this.line.length() && ((c2 = this.line.charAt(this.column)) >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F')) {
                seenDigit = true;
                ++this.column;
            }
            if (!seenDigit) {
                throw this.parseErrorInToken("Unexpected end of integer");
            }
            this.detectIntegerType();
            return true;
        }
        if (this.line.startsWith("0b", this.column) || this.line.startsWith("0B", this.column)) {
            char c3;
            this.column += 2;
            boolean seenDigit = false;
            while (this.column < this.line.length() && ((c3 = this.line.charAt(this.column)) == '0' || c3 == '1')) {
                seenDigit = true;
                ++this.column;
            }
            if (!seenDigit) {
                throw this.parseErrorInToken("Unexpected end of integer");
            }
            this.detectIntegerType();
            return true;
        }
        int endOfInteger = this.column;
        while (++endOfInteger < this.line.length() && (c = this.line.charAt(endOfInteger)) >= '0' && c <= '9') {
        }
        if (endOfInteger < this.line.length() && this.line.charAt(endOfInteger) == '.') {
            boolean isFloat;
            this.column = endOfInteger + 1;
            boolean seenFracDigit = false;
            while (this.column < this.line.length() && (c = this.line.charAt(this.column)) >= '0' && c <= '9') {
                seenFracDigit = true;
                ++this.column;
            }
            if (!seenFracDigit) {
                throw this.parseErrorInToken("Unexpected end of float");
            }
            if (this.column < this.line.length() && ((c = this.line.charAt(this.column)) == 'e' || c == 'E')) {
                ++this.column;
                if (this.column < this.line.length() && (c = this.line.charAt(this.column)) >= '+' && c <= '-') {
                    ++this.column;
                }
                boolean seenExponentDigit = false;
                while (this.column < this.line.length() && (c = this.line.charAt(this.column)) >= '0' && c <= '9') {
                    seenExponentDigit = true;
                    ++this.column;
                }
                if (!seenExponentDigit) {
                    throw this.parseErrorInToken("Unexpected end of float");
                }
            }
            boolean bl = isFloat = this.column < this.line.length() && ((c = this.line.charAt(this.column)) == 'f' || c == 'F');
            if (isFloat) {
                ++this.column;
            }
            this.lastTokenType = isFloat ? TokenType.FLOAT : TokenType.DOUBLE;
            return true;
        }
        if (this.line.charAt(this.column) == '0') {
            ++this.column;
            while (this.column < this.line.length() && (c = this.line.charAt(this.column)) >= '0' && c <= '7') {
                ++this.column;
            }
            this.detectIntegerType();
            return true;
        }
        this.column = endOfInteger;
        this.detectIntegerType();
        return true;
    }

    private void detectIntegerType() {
        char c;
        boolean isLong;
        boolean bl = isLong = this.column < this.line.length() && ((c = this.line.charAt(this.column)) == 'l' || c == 'L');
        if (isLong) {
            ++this.column;
        }
        this.lastTokenType = isLong ? TokenType.LONG : TokenType.INTEGER;
    }

    private boolean skipIdentifier() {
        if (!UnpickV3Reader.isIdentifierChar(this.line.charAt(this.column))) {
            return false;
        }
        do {
            ++this.column;
        } while (this.column < this.line.length() && UnpickV3Reader.isIdentifierChar(this.line.charAt(this.column)));
        this.lastTokenType = TokenType.IDENTIFIER;
        return true;
    }

    private boolean skipString(char quoteChar, boolean singleChar) throws UnpickSyntaxException {
        if (this.line.charAt(this.column) != quoteChar) {
            return false;
        }
        ++this.column;
        boolean seenChar = false;
        block5: while (this.column < this.line.length() && this.line.charAt(this.column) != quoteChar) {
            if (singleChar && seenChar) {
                throw this.parseErrorInToken("Multiple characters in char literal");
            }
            seenChar = true;
            if (this.line.charAt(this.column) == '\\') {
                ++this.column;
                if (this.column == this.line.length()) {
                    throw this.parseErrorInToken("Unexpected end of string");
                }
                char c = this.line.charAt(this.column);
                switch (c) {
                    case 'u': {
                        do {
                            ++this.column;
                        } while (this.column < this.line.length() && this.line.charAt(this.column) == 'u');
                        for (int i = 0; i < 4; ++i) {
                            if (this.column == this.line.length()) {
                                throw this.parseErrorInToken("Unexpected end of string");
                            }
                            c = this.line.charAt(this.column);
                            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                                throw this.parseErrorInToken("Illegal character in unicode escape sequence");
                            }
                            ++this.column;
                        }
                        continue block5;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        ++this.column;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        ++this.column;
                        int maxOctalDigits = c <= '3' ? 3 : 2;
                        for (int i = 1; i < maxOctalDigits && this.column < this.line.length() && (c = this.line.charAt(this.column)) >= '0' && c <= '7'; ++i) {
                            ++this.column;
                        }
                        continue block5;
                    }
                    default: {
                        throw this.parseErrorInToken("Illegal escape sequence \\" + c);
                    }
                }
                continue;
            }
            ++this.column;
        }
        if (this.column == this.line.length()) {
            throw this.parseErrorInToken("Unexpected end of string");
        }
        if (singleChar && !seenChar) {
            throw this.parseErrorInToken("No character in char literal");
        }
        ++this.column;
        return true;
    }

    private static boolean isTokenEnd(char c) {
        return Character.isWhitespace(c) || c == '#';
    }

    private static boolean isIdentifierChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$';
    }

    private UnpickSyntaxException expectedTokenError(String expected, String token) {
        if (this.lastTokenType == TokenType.EOF) {
            return this.parseError("Expected " + expected + " before eof token");
        }
        return this.parseError("Expected " + expected + " before " + UnpickV3Writer.quoteString(token, '\'') + " token");
    }

    private UnpickSyntaxException parseError(String message) {
        return this.parseError(message, this.lastTokenLine, this.lastTokenColumn);
    }

    private UnpickSyntaxException parseErrorInToken(String message) {
        return this.parseError(message, this.reader.getLineNumber(), this.column);
    }

    private UnpickSyntaxException parseError(String message, int lineNumber, int column) {
        return new UnpickSyntaxException(lineNumber, column + 1, message);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static {
        PRECEDENCES.put(BinaryExpression.Operator.BIT_OR, 0);
        PRECEDENCES.put(BinaryExpression.Operator.BIT_XOR, 1);
        PRECEDENCES.put(BinaryExpression.Operator.BIT_AND, 2);
        PRECEDENCES.put(BinaryExpression.Operator.BIT_SHIFT_LEFT, 3);
        PRECEDENCES.put(BinaryExpression.Operator.BIT_SHIFT_RIGHT, 3);
        PRECEDENCES.put(BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED, 3);
        PRECEDENCES.put(BinaryExpression.Operator.ADD, 4);
        PRECEDENCES.put(BinaryExpression.Operator.SUBTRACT, 4);
        PRECEDENCES.put(BinaryExpression.Operator.MULTIPLY, 5);
        PRECEDENCES.put(BinaryExpression.Operator.DIVIDE, 5);
        PRECEDENCES.put(BinaryExpression.Operator.MODULO, 5);
    }

    private static enum TokenType {
        IDENTIFIER("identifier"),
        DOUBLE("double"),
        FLOAT("float"),
        INTEGER("integer"),
        LONG("long"),
        CHAR("char"),
        STRING("string"),
        INDENT("indent"),
        NEWLINE("newline"),
        TYPE_DESCRIPTOR("type descriptor"),
        METHOD_DESCRIPTOR("method descriptor"),
        OPERATOR("operator"),
        EOF("eof");

        final String name;

        private TokenType(String name) {
            this.name = name;
        }
    }

    private record ParsedInteger(int value, int radix) {
    }

    private record ParsedLong(long value, int radix) {
    }

    private static class ParseState {
        private final int lastTokenLine;
        private final int lastTokenColumn;
        private final TokenType lastTokenType;
        @Nullable
        private final String lastDocs;

        ParseState(UnpickV3Reader reader) {
            this.lastTokenLine = reader.lastTokenLine;
            this.lastTokenColumn = reader.lastTokenColumn;
            this.lastTokenType = reader.lastTokenType;
            this.lastDocs = reader.lastDocs;
        }

        void restore(UnpickV3Reader reader) {
            reader.lastTokenLine = this.lastTokenLine;
            reader.lastTokenColumn = this.lastTokenColumn;
            reader.lastTokenType = this.lastTokenType;
            reader.lastDocs = this.lastDocs;
        }
    }
}

